% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provExplainR.R
\name{prov.explain}
\alias{prov.explain}
\alias{prov.diff.script}
\title{Provenance comparison functions}
\usage{
prov.explain(dir1, dir2, save = FALSE)

prov.diff.script(dir1, dir2, first.script = NULL, second.script = NULL)
}
\arguments{
\item{dir1}{path to first provenance directory}

\item{dir2}{path to second provenance directory}

\item{save}{if true saves the report to the file prov-explain.txt in the first directory}

\item{first.script}{name of first script.  If no value is passed in, it will use the
main script}

\item{second.script}{name of second script.  If both first and second script name
are NULL, it will use the main script form the second directory.  If second
script name is NULL, but first script name is not, it will use first script name.}
}
\description{
prov.explain reads two provenance collections and finds differences between these two versions.

prov.diff.script visualizes the differences between two versions of a script 
that were previously executed.
}
\details{
prov.explain and prov.diff.script are intended to help a user determine what
has changed if multiple executions of a script lead to different results.  prov.explain
does this by comparing provenance collected using the rdtLite or rdt packages.  
prov.diff.script compares copies of the R scripts saved in provenance directories
at the time that the scripts were executed. 

The types of differences that prov.explain can find include:
\itemize{
  \item Environmental information identifying when the scripts were executed, the version of R,
		the computing systems, the tool and version used to collect the provenance, the location
		of the provenance file, and the hash algorithm used to hash data files.
  \item Versions of libraries loaded
  \item Versions of provenance tools
  \item Contents and names of main and sourced scripts 
}

The prov.diff.script compares two versions of a script.
Users must specify the name of the first script, 
the provenance directory associated with the first execution of
the script, and the provenance directory associated with the second execution of
the script. The name of the second script is optional. If it
is omitted, the same script name is looked for in the second provenance
directory
}
\examples{
\dontrun{prov.explain("first.test.dir", "second.test.dir")}
}
