% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSE_HMM.R
\name{pse_hmm}
\alias{pse_hmm}
\title{pse_hmm}
\usage{
pse_hmm(hmm, g = 15)
}
\arguments{
\item{hmm}{The name of a profile hidden markov model file.}

\item{g}{The contiguous distance between residues.}
}
\value{
A vector of length \eqn{20 + g \times 20}, by default this is 320.
}
\description{
The first twenty numbers of this feature correspond to the means of each column of the HMM matrix
\eqn{H}. The rest of the features in the feature vector are given by correlation of the \eqn{ith} most
contiguous values along the chain per each amino acid column, where \eqn{0<i<g+1}. This creates a vector of 20 \eqn{\times}
g, and this combines with the first 20 features to create the final feature vector.
}
\note{
g must be less than the length of the protein sequence
}
\examples{
h<- pse_hmm(system.file("extdata", "1DLHA2-7", package="protHMM"))

}
\references{
Chou, K., & Shen, H. (2007). MemType-2L: A Web server for predicting membrane proteins and their types
by incorporating evolution information through Pse-PSSM. Biochemical and Biophysical Research Communications,
360(2), 339–345.
}
