% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_chat.R
\name{format_chat}
\alias{format_chat}
\title{Format a Chat Prompt}
\usage{
format_chat(
  text,
  instructions = NA,
  examples = data.frame(),
  system_message = NA
)
}
\arguments{
\item{text}{The text to be classified.}

\item{instructions}{Instructions to be included at the beginning of the prompt (format them like you would format instructions to a human research assistant).}

\item{examples}{A dataframe of "few-shot" examples. Must include one column called 'text' with the example text(s) and another column called "label" with the correct label(s).}

\item{system_message}{An optional "system message" with high-level instructions (e.g. "You are a helpful research assistant.")}
}
\value{
Returns a series of messages formatted as a list object, which can be used as an input for promptr::complete_chat() or openai::create_chat_completion().
}
\description{
Format a chat prompt to submit to OpenAI's ChatGPT or GPT-4 (particularly useful for classification tasks).
}
\examples{
data(scotus_tweets_examples)

format_chat(text = "I am disappointed with this ruling.",
                   instructions = "Decide if the statement is Positive or Negative.",
                   examples = scotus_tweets_examples)
}
