% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelProteins.R
\name{train_models}
\alias{train_models}
\title{Train machine learning models on training data}
\usage{
train_models(
  split_df,
  resample_method = "repeatedcv",
  resample_iterations = 10,
  num_repeats = 3,
  algorithm_list,
  seed = NULL,
  ...
)
}
\arguments{
\item{split_df}{A \code{split_df} object from performing \code{split_data}.}

\item{resample_method}{The resampling method to use. Default is
\code{"repeatedcv"} for repeated cross validation.
See \code{\link[caret:trainControl]{trainControl}} for
details on other available methods.}

\item{resample_iterations}{Number of resampling iterations. Default is
\code{10}.}

\item{num_repeats}{The number of complete sets of folds to compute (For
\code{resampling method = "repeatedcv"} only).}

\item{algorithm_list}{A list of classification or regression algorithms to
use.
A full list of machine learning algorithms available through
the \code{caret} package can be found here:
\url{http://topepo.github.io/caret/train-models-by-tag.html}. See below for
default options.}

\item{seed}{Numerical. Random number seed. Default is \code{NULL}}

\item{...}{Additional arguments to be passed on to
\code{\link[caret:train]{train}} function in the \code{caret} package.}
}
\value{
A list of class \code{train} for each machine-learning algorithm.
See \code{\link[caret:train]{train}} for more information on accessing
different elements of this list.
}
\description{
This function can be used to train models on protein intensity
data using different machine learning algorithms
}
\details{
\itemize{\item \code{train_models} function can be used to first
define the control parameters to be used in training models, calculate
resampling-based performance measures for models based on a given set of
machine-learning algorithms, and output the best model for each algorithm.
\item In the event that \code{algorithm_list} is not provided, a default
list of four classification-based machine-learning algorithms will be used
for building and training models. Default \code{algorithm_list}:
"svmRadial", "rf", "glm", "xgbLinear, and "naive_bayes."
\item Note: Models that fail to build are removed from the output.
\item Make sure to fix the random number seed with
\code{seed} for reproducibility}
}
\examples{
\donttest{

## Create a model_df object
covid_model_df <- pre_process(covid_fit_df, covid_norm_df)

## Split the data frame into training and test data sets
covid_split_df <- split_data(covid_model_df, seed = 8314)

## Fit models based on the default list of machine learning (ML) algorithms
covid_model_list1 <- train_models(split_df = covid_split_df, seed = 351)

## Fit models using a user-specified list of ML algorithms.
covid_model_list2 <- train_models(
  covid_split_df,
  algorithm_list = c("svmRadial", "glmboost"),
  seed = 351
)

## Change resampling method and resampling iterations.
covid_model_list3 <- train_models(
  covid_split_df,
  resample_method = "cv",
  resample_iterations = 50,
  seed = 351
)
}

}
\references{
Kuhn, Max. "Building predictive models in R using the caret
package." Journal of statistical software 28 (2008): 1-26.
}
\seealso{
\itemize{
\item \code{pre_process}
\item \code{\link[caret:trainControl]{trainControl}}
\item \code{\link[caret:train]{train}}
}
}
\author{
Chathurani Ranathunge
}
