% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projoint_diff.R
\name{projoint_diff}
\alias{projoint_diff}
\title{Estimate subgroup differences (internal)}
\usage{
projoint_diff(
  .data,
  .qoi,
  .by_var,
  .structure,
  .estimand,
  .se_method,
  .irr,
  .remove_ties,
  .ignore_position,
  .n_sims,
  .n_boot,
  .weights_1,
  .clusters_1,
  .se_type_1,
  .weights_2,
  .clusters_2,
  .se_type_2,
  .auto_cluster = TRUE,
  .seed = NULL
)
}
\arguments{
\item{.data}{A \code{\link{projoint_data}} object.}

\item{.qoi}{Optional \code{\link{projoint_qoi}}; if \code{NULL}, estimates all MMs/AMCEs.}

\item{.by_var}{Column name in \code{.data$data} defining subgroups; must be logical,
numeric/integer coded as 0/1, or factor with levels \code{"0"}/\code{"1"}.}

\item{.structure}{Must be \code{"profile_level"}.}

\item{.estimand}{Either \code{"mm"} or \code{"amce"}.}

\item{.se_method}{One of \code{"analytical"}, \code{"simulation"}, or \code{"bootstrap"}.}

\item{.irr}{\code{NULL} to estimate IRR from repeated tasks, or numeric to fix IRR.}

\item{.remove_ties}{Logical; drop ties before estimation? Default \code{TRUE}.}

\item{.ignore_position}{Ignored (subgroup analysis is profile-level only).}

\item{.n_sims}{Integer; required when \code{.se_method = "simulation"}.}

\item{.n_boot}{Integer; required when \code{.se_method = "bootstrap"}.}

\item{.weights_1, .clusters_1, .se_type_1}{Passed to \code{\link[estimatr]{lm_robust}} for IRR estimation.}

\item{.weights_2, .clusters_2, .se_type_2}{Passed to \code{\link[estimatr]{lm_robust}} for MM/AMCE estimation.}

\item{.auto_cluster}{Logical; if \code{TRUE} (default), auto-cluster on \code{id} when suitable
and no clusters are provided (applies only if the corresponding \code{.se_type_*} is \code{NULL}).}

\item{.seed}{Optional integer; sets a temporary RNG seed and restores prior state on exit.}
}
\value{
A \code{\link{projoint_results}} object containing subgroup differences with fields:
\itemize{
  \item \code{estimates}: tibble with one row per attribute/level and columns
        like \code{estimate} (group1 minus group0), \code{se}, \code{conf.low},
        \code{conf.high}, plus internal columns (\code{estimate_1}, \code{estimate_0},
        \code{se_1}, \code{se_0}) used in the diff.
  \item \code{estimand}: \code{"mm"} or \code{"amce"}.
  \item \code{structure}: \code{"profile_level"}.
  \item \code{se_method}: SE method used.
  \item \code{irr}: \code{"Estimated"} or \code{"Assumed (<value> )"}.
  \item \code{tau}: numeric reliability used (average of subgroup taus when estimated).
  \item \code{remove_ties}, \code{ignore_position}: flags echoed from inputs.
  \item \code{se_type_used}, \code{cluster_by}: details propagated from fitting calls.
  \item \code{labels}, \code{data}: design labels and the analysis data (passed through).
}
}
\description{
Worker used by \code{\link{projoint}} to compute subgroup differences
(group \code{== 1} minus group \code{== 0}) in marginal means (MMs) or
average marginal component effects (AMCEs). Supported only for
\code{.structure = "profile_level"}.
}
\seealso{
\code{\link{projoint}}, \code{\link{projoint_level}}, \code{\link{projoint_results}}
}
\keyword{internal}
