% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proccalibrad.R
\name{check_for_matching_geolocation_files_mod02nrt}
\alias{check_for_matching_geolocation_files_mod02nrt}
\title{Checks that every MODIS calibrated radiance project HDF has a matching MOD03 file}
\usage{
check_for_matching_geolocation_files_mod02nrt(moddir = getwd(),
  modtxt = "MOD02", geoloctxt = "MOD03", return_geoloc = FALSE,
  return_product = FALSE)
}
\arguments{
\item{moddir}{the string describing the directory containing the MOD02 and MOD03 files; both must be in the same directory.  Default: getwd(), which gives the present working directory.}

\item{modtxt}{the text string indicating which HDF files are the MODIS calibrated radiance product (or hypothetically, other product). Default: MOD02 (MODIS calibrated radiance product)}

\item{geoloctxt}{the text string indicating which HDF files are the MODIS geolocation files (or hypothetically, another set of files). Default: MOD03}

\item{return_geoloc}{if TRUE, return the list of unmatched geolocation files (e.g. MOD03 )}

\item{return_product}{if TRUE, return the list of unmatched product files (e.g. MOD02)}
}
\value{
data.frame of matching files; or a list of non-matching files, if \code{return_geoloc} or \code{return_product} are TRUE.
}
\description{
Each MOD02 calibrated radiance product file requires a corresponding
MOD03 geolocation file to be successfully processed with the MRTSwath tool.
}
\details{
MRTSwath is the MRT (MODIS Reprojection Tool) for the MODIS

E.g. this calibrated radiance file:

MOD021KM.A2016209.0515.005.NRT.hdf

...goes with this corresponding geolocation file:

MOD03.A2016209.0515.005.NRT.hdf

...which is a large file (~30 MB) containing detailed information
on the position, tilt, etc. of the MODIS satellite.
MRTSwath tool needs one of each, however.
}
\examples{
# Check your working directory
moddir = getwd()

# Here are some example MODIS files in mod02nrt/extdata/
# Code excluded from CRAN check because it depends on modiscdata
\dontrun{
library(devtools)
library(modiscdata)
moddir = system.file("extdata/2002raw/", package="modiscdata")

# You need to have some e.g. MOD files in it (from the MODIS-TERRA platform)
list.files(path=moddir, pattern="MOD")
list.files(path=moddir, pattern="MOD")

# Check for matches (for MODIS-TERRA platform)
check_for_matching_geolocation_files_mod02nrt(moddir=moddir, modtxt="MOD02", geoloctxt="MOD03",
 return_geoloc=FALSE, return_product=FALSE)
}

}
\author{
Rishabh Gupta \email{rishabh.uk@gmail.com}
}

