% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{inflation_expectations}
\alias{inflation_expectations}
\title{Inflation expectations data}
\format{
\subsection{\code{inflation_expectations}}{

A data frame with 290 rows and 6 columns:
\describe{
\item{inflation_pred}{Individual prediction of inflation next year (integer; e.g. 10=10\%)}
\item{age}{Age (in years)}
\item{finlit_score}{Financial literacy test score (out of 12 points)}
\item{male}{1 if male, 0 otherwise}
\item{collgrad}{1 if college graduate, 0 otherwise}
\item{famincome_hi}{1 if family income > $75,000, 0 otherwise}
}
}
}
\source{
\url{https://journaldata.zbw.eu/dataset/measuring-consumer-uncertainty-about-future-inflation}
}
\usage{
inflation_expectations
}
\description{
Data on individual inflation expectations, based on the paper: "Measuring
consumer uncertainty about future inflation," by Wandi Bruine de Bruin,
Charles F. Manski, Giorgio Topa, Wilbert van der Klaauw, 2011,
Journal of Applied Econometrics, 26: 454-478. This dataset has only the
observations with point estimates of inflation for individuals between
30 and 70 years of age. The survey took place in 2007 and 2008. The actual
inflation, for benchmark, was 3.2\% in 2006, 2.9\% in 2007, and 3.8\% in 2008.
}
\keyword{datasets}
