% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulationsfunctions.R
\name{simulate_incidence_stats}
\alias{simulate_incidence_stats}
\title{Calculate theoretical values like 
x.los, x.loi and other characteristics of the patient population}
\usage{
simulate_incidence_stats(hospital, steps = 365 * 10000,
  n.sim.pat = 5000)
}
\arguments{
\item{hospital}{type of hospital as a list-object (see vignette for details)}

\item{steps}{number of steps to evolve process}

\item{n.sim.pat}{size of simulations to estimate individual characteristics of patients}
}
\value{
list with following components \itemize{
   \item{x.los - average length of stay x_{los}} 
   \item{x.loi - average length of infection x_{loi}}
   \item{x.los.noso.only - average length of stay for patients with HAI}
   \item{x.los.wo.noso - average length of stay for patients discounting time with HAI}    
   \item{I -  theoretical incidence rate per patient day}
   \item{I.pp - list of theoretical incidences for patient types}
   \item{patient.stats - list with `x.los` and `x.loi` for different patient types}
   \item{patient.risk.times - list of patient days at risk for different patient types}
}
}
\description{
Calculate theoretical values like 
x.los, x.loi and other characteristics of the patient population
}
\examples{
pat.1 <- list(dist.X.los = create_dist_vec(
                               function(x) dpois(x-1, lambda = 12), 70),
I.p = 0.008,
dist.X.loi = create_dist_vec(function(x) dpois(x-1, lambda = 10), 70))

pat.2 <- list(dist.X.los = 
                create_dist_vec(function(x) dpois(x-1, lambda = 10), 70),
              I.p = 0.02,
              dist.X.loi = 
                create_dist_vec(function(x) dpois(x-1, lambda = 7), 70))

patient.list <- list(pat.1, pat.2)


# define distribution of patients
pat.1.prob <- 0.4; pat.2.prob <- 0.6
pat.dist.hosp <- c(pat.1.prob, pat.2.prob)
hospital.1 <- list(inc.factor = 1,
                   pat.dist = pat.dist.hosp,
                   patient.list = patient.list)
data.pps <- simulate_pps_data(n.sample=1000, steps=200, hospital=hospital.1) 
data.inc.theo <- simulate_incidence_stats(hospital.1, 365 * 1000)
# gives incidence rate I
data.inc.theo$I
# gives incidence proportion per admission
data.inc.theo$I.pp
}
