% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CIfunctions.R
\name{CI_np_bs}
\alias{CI_np_bs}
\title{Function to calculate confidence intervals I.pp for gren estimator with bootstrap method based on Grenander estimator}
\usage{
CI_np_bs(data, n_bs = 1000, alpha = 0.05)
}
\arguments{
\item{data}{data frame which contains a column `A.loi` 
with lengths of nosocomial infections up to survey point ( zero if none) and
 a column `A.los` with length of stay up to survey point}

\item{n_bs}{number of bootstrap samples to use for calculations}

\item{alpha}{confidence level}
}
\value{
single-row tibble with columns CI.lower.Ipp and CI.upper.Ipp
}
\description{
Implements a bootstrap procedure for estimation of confidence intervals for I.pp based on boostrapping 
from the length of stay/infection distributions estimated by the gren method.
}
\examples{

example.dist <- create_dist_vec(function(x) dpois(x-1, 7), max.dist = 70)
example.dist.los <- create_dist_vec(function(x) dpois(x-1, lambda = 12),
                                    max.dist = 70)
data.pps.fast <- simulate_pps_fast(n.sample=5000,
                                   P=0.05,
                                   dist.X.loi = example.dist,
                                   dist.X.los = example.dist.los)
gren_est <- calculate_I_smooth(data = data.pps.fast, method = "gren")
gren_est
CI_np_bs(data.pps.fast, n_bs = 500)
}
