% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrvar.R
\name{lr_var}
\alias{lr_var}
\title{Heteroskedastic Long run variance}
\usage{
lr_var(u, nlag = NULL, demean = TRUE)
}
\arguments{
\item{u}{P by K vector of residual series, for which we recommend to use the recursive residuals from larger model.}

\item{nlag}{Non-negative integer containing the lag length to use. If empty or not included,
nleg = min(floor(1.2*T^(1/3)),T) will be used.}

\item{demean}{Logical true of false (0 or 1) indicating whether the mean should be subtracted when computing.}
}
\value{
K by K vector of Long run variance using Newey-West (Bartlett) weights.
}
\description{
Long-run covariance estimation using Newey-West (Bartlett) weights
}
\details{
Copyright: Kevin Sheppard
Kevin.sheppard\@economics.ox.ac.uk
Revision: 3    Date: 5/1/2007
}
\examples{
x<- rnorm(15);
#Newey-West covariance with automatic BW selection
lrcov = lr_var(x)
#Newey-West covariance with 10 lags
lrcov = lr_var(x, 10)
#Newey-West covariance with 10 lags and no demeaning
lrcov = lr_var(x, 10, 0)
}
