% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form_fromSpreadsheet.R
\name{form_fromSpreadsheet}
\alias{form_fromSpreadsheet}
\title{Import a (pre)registration form specification from a spreadsheet}
\usage{
form_fromSpreadsheet(
  x,
  localBackup = NULL,
  exportGoogleSheet = TRUE,
  xlsxPkg = c("rw_xl", "openxlsx", "XLConnect"),
  silent = preregr::opts$get("silent")
)
}
\arguments{
\item{x}{The URL or path to a file.}

\item{localBackup}{If not \code{NULL}, a valid filename to write a local
backup to.}

\item{exportGoogleSheet}{If \code{x} is a URL to a Google Sheet, instead of using
thr \code{googlesheets4} package to download the data, by passing
\code{exportGoogleSheet=TRUE}, an export link will be produced and the data
will be downloaded as Excel spreadsheet.}

\item{xlsxPkg}{Which package to use to work with Excel spreadsheets.}

\item{silent}{Whether to be silent or chatty.}
}
\value{
The preregr form specification
}
\description{
With this function, you can import a (pre) registration from a
spreadsheet. See the "Creating a form from a spreadsheet" vignette
for more information. That is available at
\url{https://preregr.opens.science/articles/creating_form_from_spreadsheet.html}
or can be shown by running \code{vignette("creating_form_from_spreadsheet",
package = "preregr")}
}
\details{
An empty simple
example spreadsheet is available at
\url{https://docs.google.com/spreadsheets/d/14Qbak7JbBhTqmJaMgJ4tU9ZROaBbUfq37_UzkoHnM60}
and can be initialized as the \code{almostEmptyForm} form
with \code{\link[=prereg_initialize]{prereg_initialize()}}
}
