% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample-size.r
\name{optimal_proportion}
\alias{optimal_proportion}
\title{Unstratified Optimized Theta}
\usage{
optimal_proportion(w_sel, w_pref, w_treat, sigma2, phi, delta_pi, delta_nu)
}
\arguments{
\item{w_sel}{weight assigned to the estimation of the selection effect. Each 
weight should be a numeric value between 0 and 1 and sum of 
three weights should be 1.}

\item{w_pref}{weight assigned to the estimation of the preference effect. 
Each weight should be a numeric value between 0 and 1 and 
sum of three weights should be 1.}

\item{w_treat}{weight assigned to estimation of the treatment effect. Each 
weight should be a numeric value between 0 and 1 and sum of 
three weights should be 1.}

\item{sigma2}{variance estimate. Should be a positive numeric value.}

\item{phi}{proportion of patients preferring treatment 1. Should be numeric
value between 0 and 1.}

\item{delta_pi}{overall study preference effect.}

\item{delta_nu}{overall study selection effect.}
}
\description{
Calculates the optimal proportion of patients assigned to the choice arm
in an unstratified two-stage randomized trial
}
\examples{
optimal_proportion(w_sel=0.2, w_pref=0.4, w_treat=0.4, sigma2=1, phi=0.5,
                   delta_pi=1, delta_nu=0.5)
}
\references{
Walter et. al. (2011). "Optimal allocation of participants for
the estimation of selection, preference and treatment effects in the 
two-stage randomised trial design." \emph{Stat Med}, 
\strong{31}(13):1307-1322.
(\href{https://pubmed.ncbi.nlm.nih.gov/22362374}{PubMed})
}
