% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATE_count.R
\name{estcount.multilevel.subgroup}
\alias{estcount.multilevel.subgroup}
\title{Estimate the ATE of the log RR ratio in one multilevel subgroup defined by the proportions}
\usage{
estcount.multilevel.subgroup(
  y,
  x.cate,
  x.ps,
  time,
  trt,
  score,
  higher.y,
  prop,
  ps.method = "glm",
  minPS = 0.01,
  maxPS = 0.99
)
}
\arguments{
\item{y}{Observed outcome; vector of size \code{n} (observations)}

\item{x.cate}{Matrix of \code{p.cate} baseline covariates; dimension \code{n} by \code{p.cate} (covariates in the outcome model)}

\item{x.ps}{Matrix of \code{p.ps} baseline covariates (plus a leading column of 1 for the intercept);
dimension \code{n} by \code{p.ps + 1} (covariates in the propensity score model plus intercept)}

\item{time}{Log-transformed person-years of follow-up; vector of size \code{n}}

\item{trt}{Treatment received; vector of size \code{n} units with treatment coded as 0/1}

\item{score}{Estimated log CATE scores for all \code{n} observations from one of the four methods
(boosting, naive Poisson, two regressions, contrast regression); vector of size \code{n}}

\item{higher.y}{A logical value indicating whether higher (\code{TRUE}) or lower (\code{FALSE})
values of the outcome are more desirable. Default is \code{TRUE}.}

\item{prop}{Proportions corresponding to percentiles in the estimated log CATE scores that define subgroups to calculate ATE for;
vector of floats in `[0, 1]` always starting with 0 and ending with 1:
             Each element of \code{prop} represents inclusive cutoffs in the multilevel subgroup and the length of \code{prop}
             is number of categories in the multilevel subgroup}

\item{ps.method}{A character value for the method to estimate the propensity score. Allowed values include one of:
\code{'glm'} for logistic regression with main effects only (default), or
\code{'lasso'} for a logistic regression with main effects and LASSO penalization on
two-way interactions (added to the model if interactions are not specified in \code{ps.model}).
Relevant only when \code{ps.model} has more than one variable.}

\item{minPS}{A numerical value (in `[0, 1]`) below which estimated propensity scores should be
truncated. Default is \code{0.01}.}

\item{maxPS}{A numerical value (in `(0, 1]`) above which estimated propensity scores should be
truncated. Must be strictly greater than \code{minPS}. Default is \code{0.99}.}
}
\value{
estimated ATEs of all categories in the one multilevel subgroup; vector of size equal to the length of categories in the multilevel subgroup
}
\description{
Scores are adjusted to the opposite sign if \code{higher.y} == FALSE; scores stay the same if \code{higher.y} == TRUE;
 this is because subgroups defined in estcount.multilevel.subgroup() start from the lowest to the highest adjusted scores,
 and higher adjusted scores should always represent high responders of trt=1
}
