% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWD_resi.r
\name{PWD_resi}
\alias{PWD_resi}
\title{Fit Rocke-Lorenzato profile model to residuals}
\usage{
PWD_resi(true, resi, epsilon=1e-8, printem=FALSE)
}
\arguments{
\item{true}{the vector of values used to predict the precision – commonly X.}

\item{resi}{the vector of residuals whose variance is thought to be a function of “true”.}

\item{epsilon}{\emph{optional} (default of 1e-8) - convergence tolerance limit.}

\item{printem}{\emph{optional} (default of FALSE) - if TRUE, routine will print out results as a \code{message}.}
}
\value{
A list containing the following components:

\item{sigmar}{the estimate of \eqn{\sigma_r}}
\item{kappar}{the estimate of \eqn{\kappa_r}}
\item{L}{the -2 log likelihood}
\item{scalr}{the scaled residuals}
\item{poolsig}{the maximum likelihood estimate of \eqn{\sigma_r} if \eqn{\kappa_r} = 0}
\item{poolkap}{the maximum likelihood estimate of \eqn{\kappa_r} if \eqn{\sigma_r} = 0}
}
\description{
This routine fits the Rocke-Lorenzato precision profile model to the
\strong{residuals} from the fit.
}
\details{
The Rocke-Lorenzato precision profile model is
\deqn{SD^2 = \sigma_r^2 + (\kappa_r\cdot true)^2}
for the \emph{residuals} from a precision-profile model fit.

Under this model, the approach for reviewing residuals is to fit a
variance profile model to the residuals \eqn{r_i} themselves.  The output
of this function includes a maximum-likelihood estimate of the remaining
parameter in the special cases of:
\itemize{
\item constant variance (\eqn{\kappa_r} = 0); and
\item constant coefficient of variation (\eqn{\sigma_r} = 0).
}
}
\examples{
# library
library(ppwdeming)

# parameter specifications
sigma <- 1
kappa <- 0.08
alpha <- 1
beta  <- 1.1
true  <- 8*10^((0:99)/99)
truey <- alpha+beta*true
# simulate single sample - set seed for reproducibility
set.seed(1039)
# specifications for predicate method
X     <- sigma*rnorm(100)+true *(1+kappa*rnorm(100))
# specifications for test method
Y     <- sigma*rnorm(100)+truey*(1+kappa*rnorm(100))

# fit the model and store output
RL_gh_fit  <- PWD_get_gh(X,Y)
# run the residual analysis from the model output
post  <- PWD_resi(X, RL_gh_fit$resi, printem=TRUE)

}
\references{
Hawkins DM and Kraker JJ (in press). Precision Profile Weighted
Deming Regression for Methods Comparison. \emph{The Journal of Applied Laboratory Medicine}.
\url{doi:10.1093/jalm/jfaf183}

Hawkins DM (2014). A Model for Assay Precision.
\emph{Statistics in Biopharmaceutical Research}, \strong{6}, 263-269.
http://dx.doi.org/10.1080/19466315.2014.899511
}
\author{
Douglas M. Hawkins, Jessica J. Kraker \href{mailto:krakerjj@uwec.edu}{krakerjj@uwec.edu}
}
