% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWD_known.r
\name{PWD_known}
\alias{PWD_known}
\title{Weighted Deming Regression -- general weights}
\usage{
PWD_known(X, Y, gfun, hfun, gparms, hparms, epsilon=1e-8,
          MDL=NA, getCI=TRUE, printem=FALSE)
}
\arguments{
\item{X}{the vector of predicate readings.}

\item{Y}{the vector of test readings.}

\item{gfun}{a function with two arguments, a vector of size \emph{n} and a vector of parameters.}

\item{hfun}{a function with two arguments, a vector of size \emph{n} and a vector of parameters.}

\item{gparms}{a numeric vector containing any parameters referenced by \code{gfun}.}

\item{hparms}{a numeric vector containing any parameters referenced by \code{hfun}.}

\item{epsilon}{\emph{optional}  (default of 1.e-8) - convergence tolerance limit.}

\item{MDL}{\emph{optional}  (default of NA) - medical decision level(s).}

\item{getCI}{\emph{optional}  (default of TRUE) - allows for jackknifed standard errors on the regression and MDL.}

\item{printem}{\emph{optional}  (default of FALSE) - if TRUE, routine will print out results as a \code{message}.}
}
\value{
A list containing the following components:

\item{alpha }{the fitted intercept}
\item{beta }{the fitted slope}
\item{cor }{the Pearson correlation between X and Y}
\item{fity }{the vector of predicted Y}
\item{mu }{the vector of estimated latent true values}
\item{resi }{the vector of residuals}
\item{scalr }{the vector of scaled residuals using the specified g and h}
\item{L }{the -2 log likelihood L}
\item{sealpha }{the jackknife standard error of alpha}
\item{sebeta }{the jackknife standard error of beta}
\item{covar }{the jackknife covariance between alpha and beta}
\item{preMDL }{the predictions at the MDL(s)}
\item{preMDLl }{the lower confidence limit(s) of preMDL}
\item{preMDLu }{the upper confidence limit(s) of preMDL}
}
\description{
This code is used for the setting of known precision profiles implemented
in user-provided R functions called \code{gfun} and \code{hfun}.
}
\details{
The functions \code{gfun} and \code{hfun} are allowed as inputs,
to support flexibility in specification of the forms of these variance functions.
The known precision profiles specified by the functions \code{gfun} and \code{hfun},
when provided with estimated vectors of \eqn{\mu} and \eqn{\alpha + \beta\mu}
respectively and with any required parameters, will produce
the vectors g and h.  These vectors are then integrated into the
iterative estimation of the slope and intercept of the linear relationship
between predicate and test readings.
}
\examples{
# library
library(ppwdeming)

# parameter specifications
alpha <- 1
beta  <- 1.1
true  <- 8*10^((0:99)/99)
truey <- alpha+beta*true
# forms of precision profiles
gfun    <- function(true, gparms) {
  gvals = gparms[1]+gparms[2]*true^gparms[3]
  gvals
}
hfun    <- function(true, hparms) {
  hvals = hparms[1]+hparms[2]*true^hparms[3]
  hvals
}

# Loosely motivated by Vitamin D data set
g     <- 4e-16+0.07*true^1.27
h     <- 6e-2+7e-5*truey^2.2
# simulate single sample - set seed for reproducibility
set.seed(1039)
# specifications for predicate method
X     <- true +sqrt(g)*rnorm(100)
# specifications for test method
Y     <- truey+sqrt(h)*rnorm(100)

# fit with to estimate linear parameters
pwd_known_fit <- PWD_known(X, Y, gfun, hfun,
                           gparms=c(4e-16, 0.07, 1.27),
                           hparms=c(6e-2, 7e-5, 2.2), MDL=12,
                           printem=TRUE)

}
\author{
Douglas M. Hawkins, Jessica J. Kraker \href{mailto:krakerjj@uwec.edu}{krakerjj@uwec.edu}
}
