% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{modelSelec_QPlot}
\alias{modelSelec_QPlot}
\title{Plots for model selection}
\usage{
modelSelec_QPlot(model.selec_Q)
}
\arguments{
\item{model.selec_Q}{Output from \link[ppsbm]{modelSelection_Q}.}
}
\description{
Plots the Integrated Classification Likelihood (ICL) criterion, the Complete Log-Likelihood (CLL) and the ELBO (J criterion).
}
\examples{
# load data of a synthetic graph with 50 individuals and 3 clusters
n <- 50

# compute data matrix of counts per subinterval with precision d_max=3 :
# (ie nb of parts K=2^{d_max}=8).
K <- 2^3
data <- list(Nijk=statistics(generated_Q3$data,n,K,directed=FALSE),
    Time=generated_Q3$data$Time)

# ICL-model selection
sol.selec_Q <- modelSelection_Q(data,n,Qmin=1,Qmax=4,directed=FALSE,
    sparse=FALSE,generated_sol_hist)

# plot ICL
modelSelec_QPlot(sol.selec_Q)

}
