% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppls.splines.cv.R
\name{ppls.splines.cv}
\alias{ppls.splines.cv}
\title{Cross-Validation for Penalized PLS with Spline-Transformed Predictors}
\usage{
ppls.splines.cv(
  X,
  y,
  lambda = 1,
  ncomp = NULL,
  degree = 3,
  order = 2,
  nknot = NULL,
  k = 5,
  kernel = FALSE,
  scale = FALSE,
  reduce.knots = FALSE,
  select = FALSE
)
}
\arguments{
\item{X}{A numeric matrix of input predictors.}

\item{y}{A numeric response vector.}

\item{lambda}{A numeric vector of penalty parameters. Default is \code{1}.}

\item{ncomp}{Integer. Maximum number of PLS components. Default is \code{min(nrow(X) - 1, ncol(X))}.}

\item{degree}{Integer. Degree of B-splines (e.g., 3 for cubic splines). Default is 3.}

\item{order}{Integer. Order of the differences used in the penalty matrix. Default is 2.}

\item{nknot}{Integer or vector. Number of knots per variable (before adjustment). If \code{NULL}, defaults to \code{rep(20, ncol(X))}.}

\item{k}{Number of folds for cross-validation. Default is 5.}

\item{kernel}{Logical. Whether to use the kernel representation of PPLS. Default is \code{FALSE}.}

\item{scale}{Logical. Whether to standardize predictors to unit variance. Default is \code{FALSE}.}

\item{reduce.knots}{Logical. If \code{TRUE}, adaptively reduces the number of knots when overfitting is detected. Default is \code{FALSE}.}

\item{select}{Logical. If \code{TRUE}, applies block-wise variable selection. Default is \code{FALSE}.}
}
\value{
A list with the following components:
\describe{
\item{error.cv}{Matrix of prediction errors: rows = lambda values, columns = components.}
\item{min.ppls}{The minimum cross-validated error.}
\item{lambda.opt}{Optimal lambda value.}
\item{ncomp.opt}{Optimal number of components.}
}
}
\description{
Performs cross-validation to select the optimal number of components and penalization parameter for a penalized partial least squares model (PPLS) fitted to spline-transformed predictors.
}
\details{
This function performs the following steps for each cross-validation fold:
\enumerate{
\item Transforms predictors using B-spline basis functions via \code{\link{X2s}}.
\item Computes the penalty matrix using \code{\link{Penalty.matrix}}.
\item Fits a penalized PLS model using \code{\link{penalized.pls}} with the given lambda and number of components.
\item Evaluates prediction performance on the test fold using \code{\link{new.penalized.pls}}.
}

The optimal parameters are those minimizing the average squared prediction error across all folds.
}
\examples{
# Simulated data
set.seed(123)
X <- matrix(rnorm(30 * 100), ncol = 30)
y <- rnorm(100)

# Run CV with 3 lambdas and max 4 components
result <- ppls.splines.cv(X, y, lambda = c(1, 10, 100), ncomp = 4)
result$lambda.opt
result$ncomp.opt

}
\references{
N. Kraemer, A.-L. Boulesteix, and G. Tutz (2008). \emph{Penalized Partial Least Squares with Applications to B-Spline Transformations and Functional Data}. Chemometrics and Intelligent Laboratory Systems, 94(1), 60–69. \doi{10.1016/j.chemolab.2008.06.009}
}
\seealso{
\code{\link{X2s}}, \code{\link{Penalty.matrix}}, \code{\link{penalized.pls}}, \code{\link{penalized.pls.cv}}
}
