% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jack.ppls.R
\name{jack.ppls}
\alias{jack.ppls}
\title{Jackknife Estimation for Penalized PLS Coefficients}
\usage{
jack.ppls(
  ppls.object,
  ncomp = ppls.object$ncomp.opt,
  index.lambda = ppls.object$index.lambda
)
}
\arguments{
\item{ppls.object}{An object returned by \code{\link{penalized.pls.cv}}. Must contain the array \code{coefficients.jackknife} as well as fields \code{lambda}, \code{ncomp.opt}, and \code{index.lambda}.}

\item{ncomp}{Integer. Number of PLS components to use. Default is \code{ppls.object$ncomp.opt}.}

\item{index.lambda}{Integer. Index of the penalization parameter \code{lambda}. Default is \code{ppls.object$index.lambda}.}
}
\value{
An object of class \code{"mypls"}, which is a list containing:
\describe{
\item{coefficients}{The mean regression coefficients across cross-validation splits.}
\item{covariance}{The estimated covariance matrix of the coefficients.}
\item{k}{Number of cross-validation folds used.}
\item{ncomp}{Number of components used in estimation.}
\item{index.lambda}{Index of the lambda value used.}
}
}
\description{
This function computes jackknife estimates (mean and covariance) of the regression coefficients obtained from a cross-validated Penalized Partial Least Squares (PPLS) model.
}
\details{
The jackknife estimates are computed using the array of regression coefficients obtained in each cross-validation fold. The function returns both the mean coefficients and the associated variance-covariance matrix.

If the requested number of components \code{ncomp} or the lambda index \code{index.lambda} exceeds the available dimensions of the \code{coefficients.jackknife} array, they are adjusted to their maximum allowable values, with a message.

Note: This jackknife procedure is not discussed in Kraemer et al. (2008), but it is useful for statistical inference, such as confidence intervals or hypothesis tests.
}
\examples{
data(cookie)  # load example data
X <- as.matrix(cookie$NIR)  # NIR spectra
y <- cookie$constituents$fat    # extract one constituent

pls.object <- penalized.pls.cv(X, y, ncomp = 10, kernel = TRUE)
my.jack <- jack.ppls(pls.object)
coef(my.jack)
vcov(my.jack)
}
\references{
N. Kraemer, A.-L. Boulesteix, and G. Tutz (2008). \emph{Penalized Partial Least Squares with Applications to B-Spline Transformations and Functional Data}. Chemometrics and Intelligent Laboratory Systems, 94(1), 60–69. \doi{10.1016/j.chemolab.2008.06.009}
}
\seealso{
\code{\link{penalized.pls.cv}}, \code{\link{coef.mypls}}, \code{\link{vcov.mypls}}, \code{\link{ttest.ppls}}
}
