% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drpt.R, R/prpt.R, R/qrpt.R, R/rrpt.R
\name{ReversalPowerT}
\alias{ReversalPowerT}
\alias{drpt}
\alias{ReversalPowerT}
\alias{prpt}
\alias{ReversalPowerT}
\alias{qrpt}
\alias{ReversalPowerT}
\alias{rrpt}
\title{The Power Reversal Student t Distribution}
\usage{
drpt(x, lambda = 1, mu = 0, sigma = 1, df, log = FALSE)

prpt(q, lambda = 1, mu = 0, sigma = 1, df, lower.tail = TRUE,
  log.p = FALSE)

qrpt(p, lambda = 1, mu = 0, sigma = 1, df, lower.tail = TRUE,
  log.p = FALSE)

rrpt(n, lambda = 1, mu = 0, sigma = 1, df)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{lambda}{shape parameter.}

\item{mu, sigma}{location and scale parameters.}

\item{df}{degrees of freedom (> 0, maybe non-integer). df = Inf is allowed.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x ]}, otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\description{
Density, distribution function,
quantile function and random generation for
the power reversal Student t distribution with parameters mu, sigma, lambda and df.
}
\details{
The reversal power Student t distribution has density

\eqn{f(x)=[\lambda/\sigma][f((x-\mu)/\sigma)][F((x-\mu)/\sigma)] ^(\lambda-1)},

where \eqn{-\infty<\mu<\infty} is the location paramether, \eqn{\sigma^2>0} the scale parameter and \eqn{\lambda>0} the shape parameter.
}
\examples{
drpt(1, 1, 3, 4, 1)
prpt(1, 1, 3, 4, 1)
qrpt(0.2, 1, 3, 4, 1)
rrpt(5, 2, 3, 4, 1)
}
