% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drplaplace.R, R/prplaplace.R, R/qrplaplace.R,
%   R/rrplaplace.R
\name{ReversalPowerLaplace}
\alias{ReversalPowerLaplace}
\alias{drplaplace}
\alias{ReversalPowerLaplace}
\alias{prplaplace}
\alias{ReversalPowerLaplace}
\alias{qrplaplace}
\alias{ReversalPowerLaplace}
\alias{rrplaplace}
\title{The Power Reversal Laplace Distribution}
\usage{
drplaplace(x, lambda = 1, mu = 0, sigma = 1, log = FALSE)

prplaplace(q, lambda = 1, mu = 0, sigma = 1, lower.tail = TRUE,
  log.p = FALSE)

qrplaplace(p, lambda = 1, mu = 0, sigma = 1, lower.tail = TRUE,
  log.p = FALSE)

rrplaplace(n, lambda = 1, mu = 0, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{lambda}{shape parameter.}

\item{mu, sigma}{location and scale parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x ]}, otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\description{
Density, distribution function,
quantile function and random generation for
the power reversal Laplace distribution with parameters mu, sigma and lambda.
}
\details{
The reversal power Laplace distribution has density

\eqn{f(x)=\lambda\left[\frac{1}{2}+\frac{\left(1-e^{\frac{\left|x-\mu\right|}{\sigma}}\right)}{2}\textrm{sign}\left(-\frac{x-\mu}{\sigma}\right)\right]^{\lambda-1}\left[\frac{e^{-\frac{\left|x-\mu\right|}{\sigma}}}{2\sigma}\right]}{a},

where \eqn{-\infty<\mu<\infty} is the location paramether, \eqn{\sigma^2>0} the scale parameter and \eqn{\lambda>0} the shape parameter.
}
\examples{
drplaplace(1, 1, 3, 4)
prplaplace(1, 1, 3, 4)
qrplaplace(0.2, 1, 3, 4)
rrplaplace(5, 2, 3, 4)
}
