% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation-class.R
\name{simulation}
\alias{is.simulation}
\alias{plot.simulation}
\alias{simulation}
\title{Stochastic Simulation}
\usage{
simulation(dynamic, population, timesteps = 1, replicates = 1,
  ncores = NULL)

is.simulation(x)

\method{plot}{simulation}(x, states = NULL, patches = 1, ...)
}
\arguments{
\item{dynamic}{a population dynamic model of class \code{\link{dynamic}}}

\item{population}{a dataframe or named vector of positive integers, giving
the number of individuals in each state of \code{dynamic}. If a dataframe,
it should have only one row (as in the examples below), or as many rows as
patches in the metapopulation if a multi-patch landscape has been defined
for \code{dynamic} (using \code{\link{landscape}}). If a multi-patch
landscape has been defined for \code{dynamic}, but \code{population} has
only one row or is a vector, this population will be duplicated for all
patches in the landscape.}

\item{timesteps}{a positive integer giving the number of time steps
(iterations) over which to simulate the model}

\item{replicates}{a positive integer giving the number of independent time
series to simulate}

\item{ncores}{an optional positive integer giving the number of cpu cores to
use when running simulations. By default (when \code{ncores = NULL}) all
cores are used (or as many as \code{parallel::detectCores} can find). This
argument is ignored is \code{replicates = 1}}

\item{x}{a \code{simulation} object, or an object to be tested as a \code{simulation}}

\item{states}{a character vector naming the states in the \code{dynamic}
object used to run the simulation that should be plotted. By default all of
them are.}

\item{patches}{vector of positive integers identifying the patches for which
to plot the simulations. By default only projections for the first patch
are plotted.}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
an object of class \code{simulation}
}
\description{
Simulate a population dynamic model in discrete time, recording
  the number of individuals in each state at each time point.
}
\details{
The order of the dynamics in the simulation is defined by the order
  in which the transitions were passed to \code{dynamic}. I.e. if the stasis
  probability of a life stage (e.g. fraction surviving and remaining in the
  stage) was specified before the reproduction rate, then only those staying
  in the state will reproduce. Conversely, if reproduction was given first,
  individuals will reproduce before the stasis probability is applied.
}
\examples{
# set up a three-stage model
stasis_egg <- tr(egg ~ egg, p(0.6))
stasis_larva <- tr(larva ~ larva, p(0.4))
stasis_adult <- tr(adult ~ adult, p(0.9))
hatching <- tr(larva ~ egg, p(0.35))
fecundity <- tr(egg ~ adult, r(20))
pupation <- tr(adult ~ larva, p(0.2))

pd <- dynamic(stasis_egg,
              stasis_larva,
              stasis_adult,
              hatching,
              pupation,
              fecundity)

population <- data.frame(egg = 1200, larva = 250, adult = 50)

# simulate for 50 timesteps, 30 times
sim <- simulation(dynamic = pd,
                  population = population,
                  timesteps = 50,
                  replicates = 30,
                  ncores = 1)

is.simulation(sim)
par(mfrow = c(3, 1))
plot(sim)
}

