#' @title pop: A Flexible Syntax for Population Dynamic Modelling
#' @name pop
#' @description Models of population dynamics underpin a range of analyses and
#'   applications in ecology and epidemiology. The various approaches for
#'   fitting and analysing these models (MPMs, IPMs, ODEs, POMPs, PVA, with and
#'   without metapopulation structure) are generally fitted using different
#'   software, each with a different interface. This makes it difficult to
#'   combine various modelling approaches and data types to solve a given
#'   problem. pop aims to provide a flexible and easy to use common interface
#'   for constructing population dynamic models and enabling to them to be
#'   fitted and analysed in various ways.
#' @docType package
#' @import igraph
#' @importFrom graphics lines plot polygon
#' @importFrom grDevices grey
#' @importFrom stats dist na.omit quantile rbinom rpois rmultinom
NULL
