% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool-methods.R
\name{poolCheckout}
\alias{poolCheckout}
\alias{poolCheckout,Pool-method}
\alias{poolReturn}
\alias{poolReturn,ANY-method}
\alias{localCheckout}
\title{Check out and return object from the pool}
\usage{
poolCheckout(pool)

\S4method{poolCheckout}{Pool}(pool)

poolReturn(object)

\S4method{poolReturn}{ANY}(object)

localCheckout(pool, env = parent.frame())
}
\arguments{
\item{pool}{The pool to get the object from.}

\item{object}{Object to return}

\item{env}{Environment corresponding to the execution frame. For expert
use only.}
}
\description{
Use \code{poolCheckout()} to check out an object from the pool and
\code{poolReturn()} to return it. You will receive a warning if all objects
aren't returned before the pool is closed.

\code{localCheckout()} is a convenience function that can be used inside
functions (and other function-scoped operations like \code{shiny::reactive()}
and \code{local()}). It checks out an object and automatically returns it when
the function exits

Note that validation is only performed when the object is checked out,
so you generally want to keep the checked out around for as little time as
possible.

When pooling DBI database connections, you normally would not use
\code{poolCheckout()}. Instead, for single-shot queries, treat the pool object
itself as the DBI connection object and it will perform checkout/return for
you. And for transactions, use \code{\link[=poolWithTransaction]{poolWithTransaction()}}. See \code{\link[=dbPool]{dbPool()}} for
an example.
}
\examples{
pool <- dbPool(RSQLite::SQLite())
# For illustration only. You normally would not explicitly use
# poolCheckout with a DBI connection pool (see Description).
con <- poolCheckout(pool)
con
poolReturn(con)

f <- function() {
  con <- localCheckout(pool)
  # do something ...
}
f()

poolClose(pool)
}
