% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_pool.R
\name{vcflocus}
\alias{vcflocus}
\title{Create vcf string for all SNPs in a single locus}
\usage{
vcflocus(reference, alternative, total)
}
\arguments{
\item{reference}{is a vector with the number of reads with the reference
allele. Each entry of the vector corresponds to a different SNP.}

\item{alternative}{is a vector with the number of reads with the alternative
allele. Each entry of the vector corresponds to a different SNP.}

\item{total}{is a vector with the total number of reads observed at each SNP.
Each entry of the vector corresponds to a different SNP.}
}
\value{
is a character vector with as many entries as the number of SNPs in
the locus. Each entry of this character vector contains the information for
a single SNP coded as R,A:DP.
}
\description{
Creates a string with the information for all SNPs. The information is coded
as R,A:DP. R is the number of reads of the reference allele, A is the number
of reads of the alternative allele and DP is the total depth of coverage.
Each entry of the character string corresponds to a different SNP.
}
\keyword{internal}
