% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_tools.R
\name{extract_text_similarities}
\alias{extract_text_similarities}
\title{Extract similarities and differences in texts/segments}
\usage{
extract_text_similarities(v, comparison = "similarities", method)
}
\arguments{
\item{v}{Text vector or annotated data frame.}

\item{comparison}{How would you like to compare texts?
Options are "similarities", for comparing similarities, or "differences",
for comparing differences.
Defaults to "similarities".}

\item{method}{A method for checking similarities or differences between texts.
For similarities, defaults to "correlation" method.
Other methods for similarities include "cosine", "jaccard", "ejaccard",
"dice", "edice", "simple matching", and "hamann".
For differences, defaults to "euclidean".
Other methods for differences include "manhattan", "maximum",
"canberra", and "minkowski".
For more information on each of these methods and what are the implications
in selecting a method, please see `?quanteda.textstats::textstat_simil()`.}
}
\value{
A matrix of similarity scores between texts.
}
\description{
Extract similarities and differences in texts/segments
}
\examples{
#extract_text_similarities(US_News_Conferences_1960_1980[1:2,3])
}
