% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poismf.R
\name{predict.poismf}
\alias{predict.poismf}
\title{Predict expected count for new row(user) and column(item) combinations}
\usage{
\method{predict}{poismf}(object, a, b = NULL, nthreads = parallel::detectCores(), ...)
}
\arguments{
\item{object}{A Poisson factorization model as returned by `poismf`.}

\item{a}{Can be either: \itemize{
\item A vector of length N with the users/rows to predict - each entry will be
matched to the corresponding entry at the same position in `b` - e.g. to predict
value for entries (3,4), (3,5), and (3,6), should pass `a=c(3,3,3), b=c(3,5,6)`.
If `X` passed to `poismf` was a `data.frame`, should match with the entries in
its first column. If `X` passed to `poismf` was a matrix, should indicate the
row numbers (numeration starting at 1).
\item A sparse matrix, ideally in COO (triplets) format from package `Matrix`
(`Matrix::dgTMatrix`) or from package `SparseM` (`matrix.coo`), in which case it
will make predictions for the non-zero entries in the matrix and will output
another sparse matrix with the predicted entries as values. In this case, `b`
should not be passed. This option is not available if the `X` passed to `poismf`
was a `data.frame`.
}}

\item{b}{A vector of length N with the items/columns to predict - each entry will be
matched to the corresponding entry at the same position in `a` - e.g. to predict
value for entries (3,4), (3,5), and (3,6), should pass `a=c(3,3,3), b=c(3,5,6)`.
If `X` passed to `poismf` was a `data.frame`, should match with the entries in
its second column. If `X` passed to `poismf` was a matrix, should indicate the
column numbers (numeration starting at 1). If `a` is a sparse matrix, should not
pass `b`.}

\item{nthreads}{Number of parallel threads to use.}

\item{...}{Not used.}
}
\value{
\itemize{
\item If `a` and `b` were passed, will return a vector of length N with the
predictions  for the requested row/column combinations.
\item If `b` was not passed, will return a sparse matrix with the same entries
and shape as `a`, but with the values being the predictions from the model for
the non-missing entries. In such case, the output will be of class `Matrix::dgTMatrix`.
}
}
\description{
Predict expected count for new row(user) and column(item) combinations
}
\seealso{
\link{poismf} \link{topN} \link{factors}
}
