% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poismf.R
\name{get.factor.matrices}
\alias{get.factor.matrices}
\title{Extract Latent Factor Matrices}
\usage{
get.factor.matrices(model, add_names = TRUE)
}
\arguments{
\item{model}{A Poisson factorization model, as produced by `poismf`.}

\item{add_names}{Whether to add row names to the matrices if the indices
were internally remapped - they will only be so if the `X` passed to `poismf`
was a `data.frame`. Note that if passing `X` as `data.frame` with integer indices
to `poismf`, once row names are added, subsetting such matrix by an integer will
give the row at that position - that is, if you want to obtain the corresponding
row for ID=2 from `X` in `factors$A`, you need to use `factors$A["2", ]`, not
`factors$A[2, ]`.}
}
\value{
List with entries `A` (the user factors) and `B` (the item factors).
}
\description{
Extract the latent factor matrices for users (rows) and
columns (items) from a Poisson factorization model object, as returned
by function `poismf`.
}
\details{
If `X` passed to `poismf` was a `data.frame`, the mapping between
IDs from `X` to row numbers in `A` and column numbers in `B` are avaiable under
`model$levels_A` and `model$levels_B`, respectively. They can also be obtained
through `get.model.mappings`, and will be added as row names if
using `add_names=TRUE`. \bold{Be careful about subsetting with integers} (see
documentation for `add_names` for details).
}
\seealso{
\link{get.model.mappings}
}
