% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_naming.R
\name{affix_date}
\alias{affix_date}
\title{Put the current date into a file name}
\usage{
affix_date(
  filename,
  position = c("end", "start"),
  format = "\%Y-\%m-\%d",
  delimiter = "_",
  utc_time = TRUE
)
}
\arguments{
\item{filename}{The filename to modify.}

\item{position}{Where to place the formatted date. This could either be at
the \code{"end"} of the filename (the default) or at the \code{"start"}.}

\item{format}{A \code{\link[base:strptime]{base::strptime()}} format string for formatting the date. By
default, this is \code{"\%Y-\%m-\%d"} which expresses the date according to the ISO
8601 standard (as \code{YYYY-MM-DD}). Refer to the documentation on
\code{\link[base:strptime]{base::strptime()}} for conversion specifications if planning to use a
different format string.}

\item{delimiter}{The delimiter characters to use for separating the date
string from the original file name.}

\item{utc_time}{An option for whether to use the current UTC time to
establish the date (the default, with \code{TRUE}), or, use the system's local
time (\code{FALSE}).}
}
\value{
A character vector.
}
\description{
This function helps to affix the current date to a filename. This is useful
when writing \emph{agent} and/or \emph{informant} objects to disk as part of a
continuous process. The date can be in terms of UTC time or the local system
time. The date can be affixed either to the end of the filename (before the
file extension) or at the beginning with a customizable delimiter.

The \code{\link[=x_write_disk]{x_write_disk()}}, \code{\link[=yaml_write]{yaml_write()}} functions allow for the writing of
\strong{pointblank} objects to disk. Furthermore the \code{\link[=log4r_step]{log4r_step()}} function has
the \code{append_to} argument that accepts filenames, and, it's reasonable that a
series of log files could be differentiated by a date component in the naming
scheme. The modification of the filename string takes effect immediately but
not at the time of writing a file to disk. In most cases, especially when
using \code{affix_date()} with the aforementioned file-writing functions, the file
timestamps should approximate the time components affixed to the filenames.
}
\section{Examples}{

\subsection{The basics of creating a filename with the current date}{

Taking the generic \code{"pb_file"} name for a file, we add the current date to it
as a suffix.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{affix_date(filename = "pb_file")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] "pb_file_2022-04-01"
}\if{html}{\out{</div>}}

File extensions won't get in the way:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{affix_date(filename = "pb_file.rds")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] "pb_file_2022-04-01.rds"
}\if{html}{\out{</div>}}

The date can be used as a prefix.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{affix_date(
  filename = "pb_file",
  position = "start"
)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] "2022-04-01_pb_file"
}\if{html}{\out{</div>}}

The date pattern can be changed and so can the delimiter.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{affix_date(
  filename = "pb_file.yml",
  format = "\%Y\%m\%d",
  delimiter = "-"
)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] "pb_file-20220401.yml"
}\if{html}{\out{</div>}}
}

\subsection{Using a date-based filename in a \strong{pointblank} workflow}{

We can use a file-naming convention involving dates when writing output files
immediately after interrogating. This is just one example (any workflow
involving a \code{filename} argument is applicable). It's really advantageous to
use date-based filenames when interrogating directly from YAML in a scheduled
process.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{yaml_agent_interrogate(
  filename = system.file(
    "yaml", "agent-small_table.yml",
    package = "pointblank"
  )
) \%>\%
  x_write_disk(
    filename = affix_date(
      filename = "small_table_agent.rds",
      delimiter = "-"
    ),
    keep_tbl = TRUE,
    keep_extracts = TRUE
  )
}\if{html}{\out{</div>}}

In the above, we used the written-to-disk agent (The
\code{"agent-small_table.yml"} YAML file) for an interrogation via
\code{\link[=yaml_agent_interrogate]{yaml_agent_interrogate()}}. Then, the results were written to disk as an RDS
file. In the \code{filename} argument of \code{\link[=x_write_disk]{x_write_disk()}}, the \code{\link[=affix_date]{affix_date()}}
function was used to ensure that a daily run would produce a file whose name
indicates the day of execution.
}
}

\section{Function ID}{

13-3
}

\seealso{
The \code{\link[=affix_datetime]{affix_datetime()}} function provides the same features except it
produces a datetime string by default.

Other Utility and Helper Functions: 
\code{\link{affix_datetime}()},
\code{\link{col_schema}()},
\code{\link{from_github}()},
\code{\link{has_columns}()},
\code{\link{stop_if_not}()}
}
\concept{Utility and Helper Functions}
