% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/der_vs_state.R
\name{ind_der_state_plot_mlx}
\alias{ind_der_state_plot_mlx}
\title{Generate Derivative versus State Plot for individual parameter estimates (Monolix)}
\usage{
ind_der_state_plot_mlx(
  nn_name,
  min_state = NULL,
  max_state = NULL,
  inputs = NULL,
  est_parms = NULL,
  mlx_file = NULL,
  time_nn = FALSE,
  act = "ReLU",
  ribbon = TRUE,
  length_out = 100,
  beta = 20,
  transform = NULL
)
}
\arguments{
\item{nn_name}{(string) Name of the NN, e.g., \dQuote{c} for NNc(...)}

\item{min_state}{(numeric) Value of minimal state for which the derivative should be calculated (optional if inputs is given, ignored if inputs is defined)}

\item{max_state}{(numeric) Value of maximal state for which the derivative should be calculated (optional if inputs is given, ignored if inputs is defined)}

\item{inputs}{(numeric vector) Vector of input values for which derivatives should be calculated (optional if min_state and max_state is given)}

\item{est_parms}{(named vector; semi-optional) A data frame with estimated individual parameters from the NN 
extracted through the \emph{indparm_extractor_mlx} function. For optionality, see \strong{Details}.}

\item{mlx_file}{(string; semi-optional) (path)/name of the Monolix run. Must include ".mlxtran" and estimation bust have been run previously. For optionality, see \strong{Details}.}

\item{time_nn}{(boolean) Whether the neural network to analyze is a time-dependent neural network or not. Default values is FALSE.}

\item{act}{(string) Activation function used in the NN. Currently "ReLU" and "Softplus" available.}

\item{ribbon}{(boolean) Whether individual derivatives versus states should be summarise in a ribbon (TRUE) or
displayed as individual spaghetti plot (FALSE)}

\item{length_out}{(numeric) Number of points between min_state and max_state}

\item{beta}{(numeric) Beta value for the Softplus activation function, only applicable if \emph{act="Softplus"}; Default to 20.}

\item{transform}{(string) Mathematical exression as string to transform the NN output. Independent variable must be called NN, e.g.,
"1/(1+exp(-NN))" for sigmoidal transformation.}
}
\value{
Displaying derivative versus state plot
}
\description{
This functions allows to generate a derivative versus state plot for a neural network from a NODE in Monolix
with individual parameter estimates (EBEs).
}
\details{
Either \emph{est_parms} or \emph{mlx_file} must be given. If both arguments are given, \emph{est_parms} is prioritized.
}
\examples{
mlx_path <- system.file("extdata","mlx_example1_ind.mlxtran",package="pmxNODE")
der_state_plot <- ind_der_state_plot_mlx(nn="c",
                                         min_state=0,max_state=10,
                                         mlx_file=mlx_path)

}
\author{
Dominic Bräm
}
