% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_nm.R
\name{find_nmfe}
\alias{find_nmfe}
\title{Finde path to NONMEM nmfe file}
\usage{
find_nmfe(root = "C:/")
}
\arguments{
\item{root}{(string) Path to the root where NONMEM was installed. Default is "C:/", working if NONMEM was installed directly
into the C drive.}
}
\value{
Path and name of NONMEM nmfe file, that can directly be used as \emph{nm_path} argument in the \emph{run_nm} function.
}
\description{
To run a NONMEM model, a NONMEM nmfeXX file is required, with XX the NONMEM version. When opening the NONMEM
command prompt, working directory is usually set to folder, where the nmfe file is located. When running NONMEM
from R (with the run_nm function), the path and the nmfe file must be provided (as the nm_path argument). To facilitate
the search for the nmfe file, this function can be used.
}
\details{
This function assumes that the path to the nmfe file is "\emph{root}/nmXXXX/run/nmfeXX, with XXXX as the NONMEM version. If
any special installation settings were applied, this function might not be working.
}
\examples{
\dontrun{
nmfe_path <- find_nmfe()
run_nm(ctl_file="./test/nm_test.ctl",nm_path=nmfe_path,create_dir=FALSE)
}
}
\author{
Dominic Bräm
}
