% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap-inference.R
\name{test_f}
\alias{test_f}
\title{Bootstrap joint confidence bands and L2-norm based test on nonlinear functions}
\usage{
test_f(
  x,
  y,
  series,
  t,
  name_group_var,
  plsmm_output,
  n_boot = 1000,
  predicted = FALSE,
  show_obs = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{A matrix of predictors.}

\item{y}{A continuous vector of response variable.}

\item{series}{A variable representing different series or groups in the data modeled as a random intercept.}

\item{t}{A numeric vector indicating the time points.}

\item{name_group_var}{A character string specifying the name of the grouping variable.}

\item{plsmm_output}{Output object obtained from the \code{\link{plsmm_lasso}} function.}

\item{n_boot}{Numeric specifying the number of bootstrap samples (default is 1000).}

\item{predicted}{Logical indicating whether to plot predicted values. If \code{FALSE} only the observed time points are used.}

\item{show_obs}{Logical. If \code{TRUE} the observed time points are used for the position scale of the x-axis.}

\item{verbose}{Logical indicating whether to display bootstrap progress. Default is \code{TRUE}.}
}
\value{
A plot showing the estimated difference and confidence bands of the nonlinear functions.

A list containing:
\item{overall_test_results}{Results from the L2-norm test of equality.}
\item{CI_f}{Confidence intervals values for the difference of the estimated functions used for plotting.}
}
\description{
This function conducts a test of overall equality of two nonlinear functions
and generates confidence bands for the estimated difference of the nonlinear functions using a bootstrap method.
}
\details{
The function generate bootstrap samples and estimate the nonlinear functions for each \code{n_boot} sample.
These bootstrap estimates are then used to compute the L2-norm test of equality and the joint confidence bands.
}
\examples{

set.seed(123)
data_sim <- simulate_group_inter(
  N = 50, n_mvnorm = 3, grouped = TRUE,
  timepoints = 3:5, nonpara_inter = TRUE,
  sample_from = seq(0, 52, 13), 
  cos = FALSE, A_vec = c(1, 1.5)
)
sim <- data_sim$sim
x <- as.matrix(sim[, -1:-3])
y <- sim$y
series <- sim$series
t <- sim$t
bases <- create_bases(t)
lambda <- 0.0046
gamma <- 0.00000001
plsmm_output <- plsmm_lasso(x, y, series, t,
  name_group_var = "group", bases$bases,
  gamma = gamma, lambda = lambda, timexgroup = TRUE,
  criterion = "BIC"
)
test_f_results <- test_f(x, y, series, t,
 name_group_var = "group", plsmm_output,
 n_boot = 10
)
test_f_results[[1]]
test_f_results[[2]]


}
