% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simul_data_UniYX_binom.R
\name{simul_data_UniYX_binom}
\alias{simul_data_UniYX_binom}
\title{Data generating function for univariate binomial plsR models}
\usage{
simul_data_UniYX_binom(totdim, ncomp, link = "logit", offset = 0)
}
\arguments{
\item{totdim}{Number of columns of the X vector (from \code{ncomp} to
hardware limits)}

\item{ncomp}{Number of latent components in the model (from 2 to 6)}

\item{link}{Character specification of the link function in the mean model
(mu). Currently, "\code{logit}", "\code{probit}", "\code{cloglog}",
"\code{cauchit}", "\code{log}", "\code{loglog}" are supported.
Alternatively, an object of class "link-glm" can be supplied.}

\item{offset}{Offset on the linear scale}
}
\value{
\item{vector}{\eqn{(Y,X_1,\ldots,X_{totdim})}}
}
\description{
This function generates a single univariate binomial response value \eqn{Y}
and a vector of explanatory variables \eqn{(X_1,\ldots,X_{totdim})} drawn
from a model with a given number of latent components.
}
\details{
This function should be combined with the replicate function to give rise to
a larger dataset. The algorithm used is a modification of a port of the one
described in the article of Li which is a multivariate generalization of the
algorithm of Naes and Martens.
}
\examples{

\donttest{
layout(matrix(1:6,nrow=2))
# logit link
hist(t(replicate(100,simul_data_UniYX_binom(4,4)))[,1])
# probit link
hist(t(replicate(100,simul_data_UniYX_binom(4,4,link="probit")))[,1])
# cloglog link
hist(t(replicate(100,simul_data_UniYX_binom(4,4,link="cloglog")))[,1])
# cauchit link
hist(t(replicate(100,simul_data_UniYX_binom(4,4,link="cauchit")))[,1])
# loglog link
hist(t(replicate(100,simul_data_UniYX_binom(4,4,link="loglog")))[,1])
# log link
hist(t(replicate(100,simul_data_UniYX_binom(4,4,link="log")))[,1])
layout(1)


layout(matrix(1:6,nrow=2))
# logit link
hist(t(replicate(100,simul_data_UniYX_binom(4,4,offset=5)))[,1])
# probit link
hist(t(replicate(100,simul_data_UniYX_binom(4,4,link="probit",offset=5)))[,1])
# cloglog link
hist(t(replicate(100,simul_data_UniYX_binom(4,4,link="cloglog",offset=5)))[,1])
# cauchit link
hist(t(replicate(100,simul_data_UniYX_binom(4,4,link="cauchit",offset=5)))[,1])
# loglog link
hist(t(replicate(100,simul_data_UniYX_binom(4,4,link="loglog",offset=5)))[,1])
# log link
hist(t(replicate(100,simul_data_UniYX_binom(4,4,link="log",offset=5)))[,1])
layout(1)


layout(matrix(1:6,nrow=2))
# logit link
hist(t(replicate(100,simul_data_UniYX_binom(4,4,offset=-5)))[,1])
# probit link
hist(t(replicate(100,simul_data_UniYX_binom(4,4,link="probit",offset=-5)))[,1])
# cloglog link
hist(t(replicate(100,simul_data_UniYX_binom(4,4,link="cloglog",offset=-5)))[,1])
# cauchit link
hist(t(replicate(100,simul_data_UniYX_binom(4,4,link="cauchit",offset=-5)))[,1])
# loglog link
hist(t(replicate(100,simul_data_UniYX_binom(4,4,link="loglog",offset=-5)))[,1])
# log link
hist(t(replicate(100,simul_data_UniYX_binom(4,4,link="log",offset=-5)))[,1])
layout(1)
}

}
\references{
T. Naes, H. Martens, Comparison of prediction methods for
multicollinear data, Commun. Stat., Simul. 14 (1985) 545-576.\cr
%\url{http://dx.doi.org/10.1080/03610918508812458}\cr Baibing Li, Julian
Morris, Elaine B. Martin, Model selection for partial least squares
regression, Chemometrics and Intelligent Laboratory Systems 64 (2002), 
79-89, \doi{10.1016/S0169-7439(02)00051-5}.
}
\seealso{
\code{\link[plsRglm]{simul_data_UniYX}}
}
\author{
Frédéric Bertrand\cr
\email{frederic.bertrand@lecnam.net}\cr
\url{https://fbertran.github.io/homepage/}
}
\keyword{datagen}
\keyword{utilities}
