% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kfolds2Mclassed.R
\name{kfolds2Mclassed}
\alias{kfolds2Mclassed}
\title{Number of missclassified individuals for k-fold cross validated partial
least squares regression models.}
\usage{
kfolds2Mclassed(pls_kfolds)
}
\arguments{
\item{pls_kfolds}{a k-fold cross validated partial least squares regression
model used on binary data}
}
\value{
\item{list}{Total number of missclassified individuals vs number of
components for the first group partition} \item{list()}{\dots{}}
\item{list}{Total number of missclassified individuals vs number of
components for the last group partition}
}
\description{
This function indicates the total number of missclassified individuals for
k-fold cross validated partial least squares regression models.
}
\note{
Use \code{\link{cv.plsR}} to create k-fold cross validated partial
least squares regression models.
}
\examples{

\donttest{
data(aze_compl)
Xaze_compl<-aze_compl[,2:34]
yaze_compl<-aze_compl$y
kfolds2Mclassed(cv.plsR(object=yaze_compl,dataX=Xaze_compl,nt=10,K=8,NK=1,verbose=FALSE))
kfolds2Mclassed(cv.plsR(object=yaze_compl,dataX=Xaze_compl,nt=10,K=8,NK=2,verbose=FALSE))
rm(list=c("Xaze_compl","yaze_compl"))
}

}
\references{
Nicolas Meyer, Myriam Maumy-Bertrand et
Frédéric Bertrand (2010). Comparing the linear and the
logistic PLS regression with qualitative predictors: application to
allelotyping data. \emph{Journal de la Societe Francaise de Statistique},
151(2), pages 1-18.
\url{https://www.numdam.org/item/JSFS_2010__151_2_1_0/}
}
\seealso{
\code{\link{kfolds2coeff}}, \code{\link{kfolds2Press}},
\code{\link{kfolds2Pressind}} and \code{\link{kfolds2Mclassedind}} to
extract and transforms results from k-fold cross validation.
}
\author{
Frédéric Bertrand\cr
\email{frederic.bertrand@lecnam.net}\cr
\url{https://fbertran.github.io/homepage/}
}
\keyword{models}
\keyword{regression}
