% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mm.R
\name{plot_mm}
\alias{plot_mm}
\title{Tidy Visualization of Mixture Models}
\usage{
plot_mm(m, k = NULL, data = NULL)
}
\arguments{
\item{m}{A mixture model object}

\item{k}{Optional. The number of components specified in the mixture model, \code{m}}

\item{data}{Name of data object required only for \code{EMCluster} objects}
}
\description{
Generates a ggplot of data densities with overlaid mixture components from fit mixture models.
}
\details{
This is the core function in the package, returning a \code{ggplot} object for a fit mixture model. The plot includes the data density with overlaid mixture components.
}
\examples{
\dontrun{
if(require(mixtools)){
mixmdl1 <- mixtools::normalmixEM(faithful$waiting, k = 2)
}
plot_mm(mixmdl1, 2)

if(require(mixtools)){
x <- c(rgamma(200, shape = 50, scale = 11), rgamma(200, shape = 28, scale = 6))
mixmdl2 <- mixtools::gammamixEM(x, lambda = c(1, 1)/2)
}
plot_mm(mixmdl2)
}

}
\references{
Wickham, H., 2016. ggplot2: elegant graphics for data analysis. Springer.
}
