% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/direct.R
\name{get_all_dependencies}
\alias{get_all_dependencies}
\title{get_all_dependencies}
\usage{
get_all_dependencies(packages, level = 1L, relation = c("Depends",
  "Imports", "LinkingTo", "Suggests", "Enhances"), strict = FALSE,
  ignore = c("datasets", "utils", "grDevices", "graphics", "stats",
  "methods"))
}
\arguments{
\item{packages}{(non-empty character vector) Package names}

\item{level}{(positive integer, Default = 1L) Depth of recursive dependency}

\item{relation}{(character vector) Types of relations. Must be a subset of
c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}

\item{strict}{(logical, Default: TRUE) Whether to consider all packages
(alternately only 'relation' specific packages) when computing dependencies
for the next level}

\item{ignore}{package names to ignore}
}
\value{
A tibble with three columns: `pkg_1`, `relation` and `pkg_2`
}
\description{
Get all dependencies
}
\examples{
pkggraph::init(local = TRUE)
# general use
pkggraph::get_all_dependencies("mlr")
# specify two levels
pkggraph::get_all_dependencies("mlr", level = 2)
# specify relation(s)
pkggraph::get_all_dependencies("mlr", level = 2, relation = "Imports")
# setting strict to TRUE to only consider 'Imports' of the previous level
pkggraph::get_all_dependencies("mlr"
                               , level    = 2
                               , relation = "Imports"
                               , strict   = TRUE)
}
\seealso{
\code{\link{get_all_reverse_dependencies}}
}
\author{
Srikanth KS
}
