% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_dates.R
\name{parse_dates}
\alias{parse_dates}
\title{Parse Date and Date-Time Variables}
\usage{
parse_dates(x, tz = getOption("pkdata.tz", ""))
}
\arguments{
\item{x}{character vector of dates or date-times}

\item{tz}{character string; specifies the time zone to be used for the
conversion.  Defaults to the current time zone.}
}
\value{
vector of Date or POSIXct objects
}
\description{
Given a vector of dates or date-times, create Date or POSIXct variables.
}
\details{
\code{parse_dates} calls \code{\link[lubridate]{parse_date_time}} from the
lubridate package.  While \code{\link[lubridate]{parse_date_time}} accepts
multiple date formats, \code{parse_dates} requires a consistent format.
}
\examples{
x <- c("2014-01-15", "20140202")
parse_dates(x)
x <- c("2014-01-15 01:51", "20140202 04:35:18")
parse_dates(x)
}
\author{
Cole Beck
}
