% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareDoses.R
\name{conformDoses}
\alias{conformDoses}
\title{Create a Conforming Dose Data Set}
\usage{
conformDoses(
  doseData,
  idVar = "id",
  dateVar = "date.dose",
  infusionDoseTimeVar = NULL,
  infusionDoseVar = NULL,
  bolusDoseTimeVar = NULL,
  bolusDoseVar = NULL,
  otherDoseTimeVar = NULL,
  otherDoseVar = NULL,
  otherVars = NULL
)
}
\arguments{
\item{doseData}{data.frame; data set with dose information}

\item{idVar}{character string; name of ID variable, defaults to id}

\item{dateVar}{character string; name of date variable, defaults to date.dose}

\item{infusionDoseTimeVar}{character string; name of infusion dose time
variable}

\item{infusionDoseVar}{character string; name of infusion dose variable}

\item{bolusDoseTimeVar}{character string; name of bolus dose time variable}

\item{bolusDoseVar}{character string; name of bolus dose variable}

\item{otherDoseTimeVar}{character string; name of additional dose time
variable}

\item{otherDoseVar}{character string; name of additional dose variable}

\item{otherVars}{character string; name of other variables within data set}
}
\value{
data.frame, containing dose data
}
\description{
Modify dose data such that it conforms for future use.
}
\details{
Date-time variables are given a consistent format.  Invalid records are
removed.  The data set is sorted by date.
}
\author{
Cole Beck
}
