% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PivotCell.R
\docType{class}
\name{PivotCell}
\alias{PivotCell}
\title{R6 class that represents a cell in a pivot table.}
\format{
\code{\link[R6]{R6Class}} object.
}
\description{
The `PivotCell` class represents a cell in the body of a pivot table (i.e. not
a row/column heading, rather a cell typically containing a numerical value).
}
\examples{
# This class should only be created by the pivot table.
# It is not intended to be created outside of the pivot table.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{instanceId}}{An integer value that uniquely identifies this cell.
NB:  This number is guaranteed to be unique within the pivot table,
but the method of generation of the values may change in future, so
you are advised not to base any logic on specific values.}

\item{\code{rowNumber}}{The row number of the cell.  1 = the first (i.e. top) data
row.}

\item{\code{columnNumber}}{The column number of the cell.  1 = the first (i.e.
leftmost) data column.}

\item{\code{calculationName}}{The name of the calculation that is displayed in the
cell.}

\item{\code{calculationGroupName}}{The name of the calculation group that owns the
calculation.}

\item{\code{isEmpty}}{`TRUE` if this cell contains no data (e.g. if it is
part of a header / outline row), `FALSE` otherwise.}

\item{\code{rowFilters}}{A `PivotFilters` object containing the filters applied to
this cell from the row data groups (i.e. row headings).}

\item{\code{columnFilters}}{A `PivotFilters` object containing the filters applied to
this cell from the column data groups (i.e. column headings).}

\item{\code{rowColFilters}}{A `PivotFilters` object containing the combined filters
applied to this cell from both the row and column data groups.}

\item{\code{calculationFilters}}{The set of filters that apply to this cell to support
calculation logic.  Either a `PivotFilters` object or a `PivotFilterOverrides`
object.  See the "Appendix: Calculations" vignette for details.}

\item{\code{workingData}}{A list of filter objects that results when the
`rowColFilters` and `calculationFilters` are combined prior to calculating
the cell value.  This is a list since some cells involve multiple
calculations - where `calc$type` is "calculation" or "function", the
calculation can be based on the values of other calculations.}

\item{\code{evaluationFilters}}{The same as `workingData` generally, except
when custom calculation functions modify the filters whilst executing.}

\item{\code{rowLeafGroup}}{The row data group linked to this row.}

\item{\code{columnLeafGroup}}{The column data group linked to this column.}

\item{\code{isTotal}}{`TRUE` is this cell is a total, `FALSE` otherwise-}

\item{\code{rawValue}}{The raw cell value - i.e. unformatted, typically a numeric value.}

\item{\code{formattedValue}}{The formatted value - typically a character value.}

\item{\code{baseStyleName}}{The name of the style that defines the visual
appearance of the cell.}

\item{\code{style}}{A `PivotStyle` object that assists in managing the CSS
style declarations that override the base style.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PivotCell-new}{\code{PivotCell$new()}}
\item \href{#method-PivotCell-setStyling}{\code{PivotCell$setStyling()}}
\item \href{#method-PivotCell-getCopy}{\code{PivotCell$getCopy()}}
\item \href{#method-PivotCell-asList}{\code{PivotCell$asList()}}
\item \href{#method-PivotCell-asJSON}{\code{PivotCell$asJSON()}}
\item \href{#method-PivotCell-clone}{\code{PivotCell$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotCell-new"></a>}}
\if{latex}{\out{\hypertarget{method-PivotCell-new}{}}}
\subsection{Method \code{new()}}{
Create a new `PivotCell` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotCell$new(
  parentPivot,
  rowNumber = NULL,
  columnNumber = NULL,
  calculationName = NULL,
  calculationGroupName = NULL,
  isEmpty = FALSE,
  rowFilters = NULL,
  columnFilters = NULL,
  rowColFilters = NULL,
  rowLeafGroup = NULL,
  columnLeafGroup = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parentPivot}}{The pivot table that this `PivotCell`
instance belongs to.}

\item{\code{rowNumber}}{The row number of the cell.  1 = the first (i.e. top) data
row.}

\item{\code{columnNumber}}{The column number of the cell.  1 = the first (i.e.
leftmost) data column.}

\item{\code{calculationName}}{The name of the calculation that is displayed in the
cell.}

\item{\code{calculationGroupName}}{The name of the calculation group that owns the
calculation.}

\item{\code{isEmpty}}{`TRUE` if this cell contains no data (e.g. if it is
part of a header / outline row), `FALSE` otherwise.}

\item{\code{rowFilters}}{A `PivotFilters` object containing the filters applied to
this cell from the row data groups (i.e. row headings).}

\item{\code{columnFilters}}{A `PivotFilters` object containing the filters applied to
this cell from the column data groups (i.e. column headings).}

\item{\code{rowColFilters}}{A `PivotFilters` object containing the combined filters
applied to this cell from both the row and column data groups.}

\item{\code{rowLeafGroup}}{The row data group linked to this row.}

\item{\code{columnLeafGroup}}{The column data group linked to this column.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `PivotCell` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotCell-setStyling"></a>}}
\if{latex}{\out{\hypertarget{method-PivotCell-setStyling}{}}}
\subsection{Method \code{setStyling()}}{
An internal method used to set style declarations on the cell.
Using `pt$setStyling(cells=x)` is preferred for users.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotCell$setStyling(styleDeclarations = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{styleDeclarations}}{A list containing CSS style declarations.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotCell-getCopy"></a>}}
\if{latex}{\out{\hypertarget{method-PivotCell-getCopy}{}}}
\subsection{Method \code{getCopy()}}{
Non-functional legacy method soon to be removed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotCell$getCopy()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns an empty list.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotCell-asList"></a>}}
\if{latex}{\out{\hypertarget{method-PivotCell-asList}{}}}
\subsection{Method \code{asList()}}{
Return the contents of this object as a list for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotCell$asList()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotCell-asJSON"></a>}}
\if{latex}{\out{\hypertarget{method-PivotCell-asJSON}{}}}
\subsection{Method \code{asJSON()}}{
Return the contents of this object as JSON for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotCell$asJSON()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A JSON representation of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotCell-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PivotCell-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotCell$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
