% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalisrR6.R
\name{normalisr}
\alias{normalisr}
\title{Creates a recommended classInt based on the type of distribution.}
\description{
Creates a recommended classInt based on the type of distribution.

Creates a recommended classInt based on the type of distribution.
}
\details{
Creates a normalisr R6 class for recommending a classInt based on the shape
of the distribution of the observed data
}
\examples{
set.seed(12345)

# Binary distribution test
x <- sample(c(0,1), 100, replace = TRUE)
y <- sample(c(0,1), 100, replace = TRUE)
mdl <- normalisr$new(x)
print(mdl)
mdl$plot()
mdl$hist()
head(mdl$as.data.frame())
mdl$applyto(y)

# Uniform distribution test
x <- runif(100)
y <- runif(100)
mdl <- normalisr$new(x)
print(mdl)
mdl$plot()
mdl$hist()
head(mdl$as.data.frame())
mdl$applyto(y)


# Normal distribution tests
x <- rnorm(100)
y <- rnorm(100)
mdl <- normalisr$new(x)
print(mdl)
mdl$plot()
mdl$hist()
head(mdl$as.data.frame())
mdl$applyto(y)

# Lognormal distribution tests
x <- rlnorm(100)
y <- rlnorm(100)
mdl <- normalisr$new(x)
print(mdl)
mdl$plot()
mdl$hist()
head(mdl$as.data.frame())
mdl$applyto(y)

# Lognormal distribution tests with 5 classes
x <- rlnorm(100)
y <- rlnorm(100)
mdl <- normalisr$new(x, num_classes = 5)
print(mdl)
mdl$plot()
mdl$hist()
head(mdl$as.data.frame())
mdl$applyto(y)

# Exponential distribution test
x <- exp(1:100)
y <- exp(1:100)
mdl <- normalisr$new(x)
print(mdl)
mdl$plot()
mdl$hist()
head(mdl$as.data.frame())
mdl$applyto(y)

# Poisson distribution test
x <- rpois(100, lambda = 0.5)
y <- rpois(100, lambda = 0.5)
mdl <- normalisr$new(x)
print(mdl)
mdl$plot()
mdl$hist()
head(mdl$as.data.frame())
mdl$applyto(y)

# Weibull distribution test
x <- rweibull(100, shape = 0.5)
y <- rweibull(100, shape = 0.5)
mdl <- normalisr$new(x)
print(mdl)
mdl$plot()
mdl$hist()
head(mdl$as.data.frame())
mdl$applyto(y)

# Set user defined breaks
mdl$setManualBreaks(c(5,10))
print(mdl)
mdl$plot()
mdl$hist()
head(mdl$as.data.frame())
mdl$applyto(y)

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{data}}{(\code{numeric()})\cr
Original observations}

\item{\code{outliers}}{(\code{logical()})\cr
Logical vector indicating is observations are
outliers}

\item{\code{quantiles}}{(\code{numeric()})\cr
Vector of quantiles}

\item{\code{fitted_distribution}}{(\code{character()})\cr
Suggested distribution}

\item{\code{normalisation}}{(\code{character()})\cr
Recommended class interval style based on
distribution}

\item{\code{breaks}}{(\code{numeric()})\cr
Recommended breaks for classes}

\item{\code{number_of_classes}}{(\code{numeric()})\cr
Number of classes identified}

\item{\code{normalised_data}}{(\code{numeric()})\cr
Normalised values based on recommendations}

\item{\code{polarity}}{(\code{numeric(1)})\cr
Which direction should the normalisation occur}

\item{\code{percentiles}}{(\code{numeric()})\cr
Observation percentiles}

\item{\code{fittedmodel}}{(\code{character()})\cr
Fitted univariate model}

\item{\code{model}}{(\code{univariateML()})\cr
Fitted univariate model parameters}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-normalisr-new}{\code{normalisr$new()}}
\item \href{#method-normalisr-print}{\code{normalisr$print()}}
\item \href{#method-normalisr-plot}{\code{normalisr$plot()}}
\item \href{#method-normalisr-hist}{\code{normalisr$hist()}}
\item \href{#method-normalisr-setManualBreaks}{\code{normalisr$setManualBreaks()}}
\item \href{#method-normalisr-applyto}{\code{normalisr$applyto()}}
\item \href{#method-normalisr-as.data.frame}{\code{normalisr$as.data.frame()}}
\item \href{#method-normalisr-clone}{\code{normalisr$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-normalisr-new"></a>}}
\if{latex}{\out{\hypertarget{method-normalisr-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6}
class.


Create a new normalisr object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{normalisr$new(
  x,
  polarity = 1,
  classint_preference = "jenks",
  num_classes = NULL,
  potential_distrs = c("unif", "power", "norm", "lnorm", "weibull", "pareto", "exp")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A numeric vector of observations}

\item{\code{polarity}}{Which direction should the normalisation occur, defaults
to 1 but can either be:
\itemize{
\item \strong{1:}: Lowest value is normalised to 0, highest value is
normalised to 1
\item \strong{-1:} Highest value is normalised to 0, lowest value is
normalised to 1
}}

\item{\code{classint_preference}}{Preference for classInt breaks
(see \code{?classInt::classIntervals})}

\item{\code{num_classes}}{Preference for number of classInt breaks,
defaults to Sturges number (see \cr
\code{?grDevices::nclass.Sturges})}

\item{\code{potential_distrs}}{The types of distributions to fit,
defaults to \code{c("unif", "power", "norm", "lnorm", "weibull", "pareto", "exp")}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{normalisr} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-normalisr-print"></a>}}
\if{latex}{\out{\hypertarget{method-normalisr-print}{}}}
\subsection{Method \code{print()}}{
Prints the normalisr
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{normalisr$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-normalisr-plot"></a>}}
\if{latex}{\out{\hypertarget{method-normalisr-plot}{}}}
\subsection{Method \code{plot()}}{
Plots the normalised values against the original
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{normalisr$plot()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-normalisr-hist"></a>}}
\if{latex}{\out{\hypertarget{method-normalisr-hist}{}}}
\subsection{Method \code{hist()}}{
Histogram of normalised values against the
original
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{normalisr$hist()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-normalisr-setManualBreaks"></a>}}
\if{latex}{\out{\hypertarget{method-normalisr-setManualBreaks}{}}}
\subsection{Method \code{setManualBreaks()}}{
Allows user to set manual breaks
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{normalisr$setManualBreaks(brks)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{brks}}{User Defined Breaks}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-normalisr-applyto"></a>}}
\if{latex}{\out{\hypertarget{method-normalisr-applyto}{}}}
\subsection{Method \code{applyto()}}{
Applies the normalisation model to new data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{normalisr$applyto(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A numeric vector of observations}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-normalisr-as.data.frame"></a>}}
\if{latex}{\out{\hypertarget{method-normalisr-as.data.frame}{}}}
\subsection{Method \code{as.data.frame()}}{
Returns a data frame of the normalisation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{normalisr$as.data.frame()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-normalisr-clone"></a>}}
\if{latex}{\out{\hypertarget{method-normalisr-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{normalisr$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
