% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pie.R
\name{plot_spatial_membership}
\alias{plot_spatial_membership}
\title{Visualize spatial memberships}
\usage{
plot_spatial_membership(
  omega,
  pol,
  radius = NULL,
  col = hcl.colors(5),
  pie_control = list(),
  legend = FALSE,
  legend_pie = FALSE,
  type = c("pie", "blend"),
  ...
)
}
\arguments{
\item{omega}{a matrix of phyloregion of probabilities of each species}

\item{pol}{a vector polygon of grid cells with a column labeled
\dQuote{grids}.}

\item{radius}{Radius of the pie legend to be displayed}

\item{col}{List of colors for the pies.}

\item{pie_control}{The list of control parameters to be passed into
the add.pie function.}

\item{legend}{Logical, whether to plot a legend or not.}

\item{legend_pie}{Legend for the pie plots.}

\item{type}{Type of visualization, whether piecharts or blended colors.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
Returns no value, just map color pies in geographic space!
}
\description{
Visualize spatial memberships
}
\examples{
library(terra)
data(africa)
p <- vect(system.file("ex/sa.json", package = "phyloregion"))
K <- ncol(africa$omega)

CLRS <- hcl.colors(K)
plot_spatial_membership(africa$omega, pol = p, col=CLRS, type="blend")
}
