% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutation_test.R
\name{permutation_test_ci}
\alias{permutation_test_ci}
\title{Construct confidence interval by inverting permutation tests}
\usage{
permutation_test_ci(
  df,
  group_col,
  outcome_col,
  strata_col = NULL,
  test_stat = "diff_in_means",
  perm_func = permute_group,
  upper_bracket = NULL,
  lower_bracket = NULL,
  cl = 0.95,
  e = 0.1,
  reps = 10000,
  perm_set = NULL,
  seed = 42
)
}
\arguments{
\item{df}{A data frame}

\item{group_col}{The name of the column in df that corresponds to the group label}

\item{outcome_col}{The name of the column in df that corresponds to the outcome variable}

\item{strata_col}{The name of the column in df that corresponds to the strata}

\item{test_stat}{Test statistic function}

\item{perm_func}{Function to permute group}

\item{upper_bracket}{Array with 2 values that bracket upper confidence bound}

\item{lower_bracket}{Array with 2 values that bracket lower confidence bound}

\item{cl}{Confidence level, default 0.95}

\item{e}{Maximum distance from true confidence bound value}

\item{reps}{Number of iterations to use when calculating permutation p-value}

\item{perm_set}{Matrix of group assignments to use instead of reps iterations of perm_func}

\item{seed}{An integer seed value}
}
\value{
A list containing the permutation test p-value, and the test statistic distribution if applicable
}
\description{
This function constructs a confidence interval by inverting permutation tests and applying the method in Glazer and Stark, 2024.
}
\examples{
x <- c(35.3, 35.9, 37.2, 33.0, 31.9, 33.7, 36.0, 35.0, 33.3, 33.6, 37.9, 35.6, 29.0, 33.7, 35.7)
y <- c(32.5, 34.0, 34.4, 31.8, 35.0, 34.6, 33.5, 33.6, 31.5, 33.8, 34.6)
df <- data.frame(outcome = c(x, y), group = c(rep(1, length(x)), rep(0, length(y))))
permutation_test_ci(df = df, group_col = "group", outcome_col = "outcome", strata_col = NULL,
                    test_stat = "diff_in_means", perm_func = permute_group,
                    upper_bracket = NULL, lower_bracket = NULL,
                    cl = 0.95, e = 0.01, reps = 10^3, seed = 42)
}
