% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabilize.R
\name{stabilize}
\alias{stabilize}
\title{Stabilization of mutation matrix}
\usage{
stabilize(mutmat, afreq = NULL, method = "PM", details = FALSE)
}
\arguments{
\item{mutmat}{A mutation matrix.}

\item{afreq}{A vector of allele frequencies.}

\item{method}{Either "DP", "RM" or "PM". Currently only "PM" is implemented.}

\item{details}{A logical. If TRUE, the complete Familias output is included.}
}
\value{
An object of the same class the input \code{mutmat}; either a matrix, a
\code{mutationMatrix} or a \code{mutationModel}.
}
\description{
NB: REPLACED BY \link{makeStationary}. Produces a mutation matrix close to the
input \code{mutmat}, for which the given frequency vector is the stationary
distribution. Several methods for doing this are described by Simonsson and
Mostad (2016); only the "PM" method is included here.
}
\details{
This function is based on, and reuses code from, the \code{stabilize()} method of
the Familias R package.
}
\examples{

afreq = c(`1` = .2, `2` = .3, `3` = .5)
m = mutationMatrix("stepwise", afreq = afreq,
                   rate = 0.1, rate2 = 0.01, range = 0.1)
m
stabilize(m)


### Example with full model (i.e., male and female)

M = mutationModel("stepwise", alleles = 1:3, afreq = afreq,
                   rate = list(male = 0.1, female = 0.2),
                   rate2 = 0.01, range = 0.1)
M
stabilize(M)

}
\references{
Simonsson, Mostad: Stationary Mutation models. (FSI: Genetics,
2016).
}
\author{
Petter Mostad, Thore Egeland, Ivar Simonsson, Magnus D. Vigeland
}
