% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdynmc_exploratory.R
\name{pDensTime.plot}
\alias{pDensTime.plot}
\title{Plot Empirical Density of a Column of a Panel Dataset over Time.}
\usage{
pDensTime.plot(
  object,
  var.name,
  i.name,
  t.name,
  aggregate.t = NULL,
  plot.quantiles = TRUE,
  plot.mean_ci = TRUE,
  plot.extrema = TRUE,
  col.set = c("gray", "navy", "darkorange1", "red"),
  ...
)
}
\arguments{
\item{object}{An object of class `data.frame`.}

\item{var.name}{Column name of the variable that is
plotted (see `Details').}

\item{i.name}{Column name of cross-section identifier.}

\item{t.name}{Column name of time-series identifier.}

\item{aggregate.t}{Argument of data type `numeric'.
If argument is specified, the corresponding number
of time periods is merged (approximately); (defaults
to 'NULL').}

\item{plot.quantiles}{Argument of data type `logical',
indicating whether the 5\%- and 95\%-quantiles and
the quartiles should be plotted (as specified by
`col.set[2]'; defaults to 'TRUE').}

\item{plot.mean_ci}{Argument of data type `logical',
indicating whether the mean and the approximate
confidence intervals (mean plus/minus 2 standard
deviations) should be plotted (as specified by
`col.set[3]'; defaults to 'TRUE').}

\item{plot.extrema}{Argument of data type `logical',
indicating whether the minimal and maximal observed
value (per time period/group) should be plotted
(as specified by `col.set[4]'; defaults to 'TRUE').}

\item{col.set}{Vector of length 4 with entries of
data type `character' used to visualize the entities
of `pDensTime.plot' (see `Details'); must be a
valid argument to `col2rgb'; defaults to
`c("gray", "navy", "darkorange1", "red")'.}

\item{...}{further arguments.}
}
\value{
Returns a plot that visualizes the empirical
   density for a column of a panel dataset
   contained in an object of class `data.frame`. The
   variable of interest is plotted on the ordinate,
   the longitudinal dimension on the abscissa. For each
   time period or aggregate of time periods, one
   empirical density is computed and plotted.
   Corresponding summary statistics on empirical
   quantiles and the sample size per longitudinal
   dimension are included in the plot.
}
\description{
\code{pDensTime.plot} Plot the empirical density
   of a column of an object of class `data.frame`
   containing a panel dataset across time
   periods/aggregates of time periods.
}
\examples{
## Load data
data(ABdata, package = "pdynmc")
dat <- ABdata
dat[,c(4:7)] <- log(dat[,c(4:7)])

## Minimal set of arguments
pDensTime.plot(object = ABdata, var.name = "emp", i.name = "firm", t.name = "year")

## All arguments explicitly stated
pDensTime.plot(object	= ABdata, var.name	= "emp", i.name	= "firm", t.name	= "year",
 aggregate.t	= NULL,	plot.quantiles	= TRUE, plot.mean_ci	= TRUE, plot.extrema	= TRUE,
 col.set		= c("gray", "navy", "darkorange1", "red"))

## Aggregation over time periods (3 time periods per group)
pDensTime.plot(object = ABdata, var.name = "emp", i.name = "firm", t.name = "year",
 aggregate.t = 3)

## Employ alternative colouring scheme
pDensTime.plot(object = ABdata, var.name = "emp", i.name = "firm", t.name = "year",
 col.set		= c("pink", "blue", "purple", "black"))

## Plot only density, mean, and asymptotic confidence interval
pDensTime.plot(object = ABdata, var.name = "emp", i.name = "firm", t.name = "year",
 plot.quantiles	= FALSE, plot.extrema	= FALSE)

}
\seealso{
\code{\link{pdynmc}} for fitting a linear dynamic panel data model.
}
\author{
Markus Fritsch, Joachim Schnurbus
}
