% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert_NA_and_try_to_shift.R
\name{insert_NA_and_try_to_shift}
\alias{insert_NA_and_try_to_shift}
\title{insert_NA_and_try_to_shift}
\usage{
insert_NA_and_try_to_shift(x, x_values, y)
}
\arguments{
\item{x}{factor vector to indicate conditions or phases (e.g., "A" and "B")}

\item{x_values}{numerical vector with distance (time markers) between observations}

\item{y}{numeric vector with the observed y-values}
}
\value{
List with the modified x, x_values, y:
  x = factor vector with conditions or phases (e.g., "A" and "B").
  x_values = (optional) vector with distance (time markers) between observations.
  y = vector with observed values.
}
\description{
Makes the input time series equidistant.
This is recommended before performing a permutation distancing test.
This function first inserts NA's for missing x_values,
then it tries to shift double value to previous or next NA's,
finally it aggregates the remaining identical x_values.
}
\examples{
pdt::insert_NA_and_try_to_shift(as.factor(c("A","A","A","B","B","B")),
  c(1,2,4,5,6,8), c(1.1,3.2,5.3,7.1,8.3,9.8))

}
