% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge3D.R
\name{num.arcsPEtetra}
\alias{num.arcsPEtetra}
\title{Number of arcs of Proportional Edge Proximity Catch Digraphs (PE-PCDs)
and quantities related to the tetrahedron - one tetrahedron case}
\usage{
num.arcsPEtetra(Xp, th, r, M = "CM")
}
\arguments{
\item{Xp}{A set of 3D points which constitute the vertices of PE-PCD.}

\item{th}{A \eqn{4 \times 3} matrix with each row representing a vertex of the tetrahedron.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{The center to be used in the construction of the vertex regions in the tetrahedron, \code{th}.
Currently it only takes \code{"CC"} for circumcenter and \code{"CM"} for center of mass; default=\code{"CM"}.}
}
\value{
A \code{list} with the elements
\item{desc}{A short description of the output: number of arcs
and quantities related to the tetrahedron}
\item{num.arcs}{Number of arcs of the PE-PCD}
\item{tri.num.arcs}{Number of arcs of the induced subdigraph of the PE-PCD
for vertices in the tetrahedron \code{th}}
\item{num.in.tetra}{Number of \code{Xp} points in the tetrahedron, \code{th}}
\item{ind.in.tetra}{The vector of indices of the \code{Xp} points that reside in the tetrahedron}
\item{tess.points}{Tessellation points, i.e., points on which the tessellation of
the study region is performed, here,
tessellation points are the vertices of the support tetrahedron \code{th}.}
\item{vertices}{Vertices of the digraph, \code{Xp}.}
}
\description{
An object of class \code{"NumArcs"}.
Returns the number of arcs of
Proportional Edge Proximity Catch Digraphs (PE-PCDs)
whose vertices are the
given 3D numerical data set, \code{Xp}.
It also provides number of vertices
(i.e., number of data points inside the tetrahedron)
and indices of the data points that reside in the tetrahedron.

PE proximity region is constructed with respect to the tetrahedron \code{th} and
vertex regions are based on the center \code{M} which is circumcenter (\code{"CC"}) or
center of mass (\code{"CM"}) of \code{th} with default=\code{"CM"}.
For the number of arcs, loops are not
allowed so arcs are only possible for points inside the tetrahedron \code{th} for this function.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010;textual}{pcds}).
}
\examples{
\donttest{
A<-c(0,0,0); B<-c(1,0,0); C<-c(1/2,sqrt(3)/2,0); D<-c(1/2,sqrt(3)/6,sqrt(6)/3)
tetra<-rbind(A,B,C,D)

n<-10  #try also n<-20
set.seed(1)
Xp<-runif.tetra(n,tetra)$g

M<-"CM"  #try also M<-"CC"
r<-1.25

Narcs = num.arcsPEtetra(Xp,tetra,r,M)
Narcs
summary(Narcs)
#plot(Narcs)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{num.arcsPEtri}}, \code{\link{num.arcsCStri}},
and \code{\link{num.arcsAStri}}
}
\author{
Elvan Ceyhan
}
