% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim1D.R
\name{inci.matCS1D}
\alias{inci.matCS1D}
\title{Incidence matrix for Central Similarity Proximity Catch Digraphs (CS-PCDs)
for 1D data - multiple interval case}
\usage{
inci.matCS1D(Xp, Yp, t, c = 0.5)
}
\arguments{
\item{Xp}{a set of 1D points which constitutes the vertices of the digraph.}

\item{Yp}{a set of 1D points which constitutes the end points of the intervals
that partition the real line.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside middle intervals
with the default \code{c=.5}.
For the interval, \code{int}\eqn{=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}
}
\value{
Incidence matrix for the CS-PCD with vertices being 1D data set, \code{Xp},
and \code{Yp} determines the end points of the intervals (the multi-interval case)
}
\description{
Returns the incidence matrix for the CS-PCD
for a given 1D numerical data set, \code{Xp},
as the vertices of the digraph and
\code{Yp} determines the end points of the intervals (in the multi-interval case).
If there are duplicates of \code{Yp} points,
only one point is retained for each duplicate value,
and a warning message is printed.
Loops are allowed, so the diagonal entries are all equal to 1.

CS proximity region is constructed
with an expansion parameter \eqn{t>0} and a centrality parameter \eqn{c \in (0,1)}.

See also (\insertCite{ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
t<-2
c<-.4
a<-0; b<-10;
nx<-10; ny<-4

set.seed(1)
Xp<-runif(nx,a,b)
Yp<-runif(ny,a,b)

IM<-inci.matCS1D(Xp,Yp,t,c)
IM
dom.num.greedy(IM)
\donttest{
dom.num.exact(IM)  #might take a long time depending on nx
}
Idom.num.up.bnd(IM,5)

Arcs<-arcsCS1D(Xp,Yp,t,c)
Arcs
summary(Arcs)
plot(Arcs)

inci.matCS1D(Xp,Yp+10,t,c)

t<-2
c<-.4
a<-0; b<-10;
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

Xp<-runif(nx,a,b)
Yp<-runif(ny,a,b)

inci.matCS1D(Xp,Yp,t,c)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{inci.matCS1D}}, \code{\link{inci.matPEtri}}, and \code{\link{inci.matPE}}
}
\author{
Elvan Ceyhan
}
