% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UndClassFunctions.R
\name{print.NumEdges}
\alias{print.NumEdges}
\title{Print a \code{NumEdges} \code{object}}
\usage{
\method{print}{NumEdges}(x, ...)
}
\arguments{
\item{x}{A \code{NumEdges} \code{object}.}

\item{\dots}{Additional arguments for the S3 method \code{'print'}.}
}
\value{
The \code{call} of the \code{object} of class \code{"NumEdges"}
and also the \code{desc} (i.e. a brief description)
of the output: number of edges in the underlying or reflexivity graph of
the proximity catch digraph (PCD) and
related quantities in the induced subgraphs for points in the Delaunay cells.
}
\description{
Prints the \code{call} of the \code{object}
of class \code{"NumEdges"}
and also the \code{desc} (i.e. a brief description) of the output.
}
\examples{
#\donttest{
nx<-15; ny<-5;
set.seed(1)
Xp<-cbind(runif(nx),runif(nx))
Yp<-cbind(runif(ny,0,.25),
runif(ny,0,.25))+cbind(c(0,0,0.5,1,1),c(0,1,.5,0,1))

M<-c(1,1,1)  #try also M<-c(1,2,3)

Nedges = num.edgesAS(Xp,Yp,M)
Nedges
print(Nedges)

typeof(Nedges)
attributes(Nedges)
#}

}
\seealso{
\code{\link{summary.NumEdges}}, \code{\link{print.summary.NumEdges}},
and \code{\link{plot.NumEdges}}
}
