% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSimUG2D.R
\name{plotCSedges.tri}
\alias{plotCSedges.tri}
\title{The plot of the edges of the underlying or reflexivity graphs of
the Central Similarity Proximity Catch Digraph
(CS-PCD) for 2D data - one triangle case}
\usage{
plotCSedges.tri(
  Xp,
  tri,
  t,
  M = c(1, 1, 1),
  ugraph = c("underlying", "reflexivity"),
  asp = NA,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  edge.reg = FALSE,
  ...
)
}
\arguments{
\item{Xp}{A set of 2D points
which constitute the vertices of the underlying
or reflexivity graphs of the CS-PCD.}

\item{tri}{A \eqn{3 \times 2} matrix with each row
representing a vertex of the triangle.}

\item{t}{A positive real number
which serves as the expansion parameter in CS proximity region.}

\item{M}{A 2D point in Cartesian coordinates
or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri};
default is \eqn{M=(1,1,1)}, i.e., the center of mass of \code{tri}.}

\item{ugraph}{The type of the graph based on CS-PCDs,
\code{"underlying"} is for the underlying graph,
and \code{"reflexivity"} is for
the reflexivity graph (default is \code{"underlying"}).}

\item{asp}{A \code{numeric} value,
giving the aspect ratio \eqn{y/x} (default is \code{NA}),
see the official help page for \code{asp} by
typing "\code{? asp}".}

\item{main}{An overall title for the plot (default=\code{NULL}).}

\item{xlab, ylab}{Titles for the \eqn{x} and \eqn{y} axes,
respectively (default=\code{NULL} for both).}

\item{xlim, ylim}{Two \code{numeric} vectors of length 2,
giving the \eqn{x}- and \eqn{y}-coordinate ranges
(default=\code{NULL} for both).}

\item{edge.reg}{A logical argument to add edge regions to the plot,
default is \code{edge.reg=FALSE}.}

\item{\dots}{Additional \code{plot} parameters.}
}
\value{
A plot of the edges of the underlying
or reflexivity graphs of the CS-PCD
whose vertices are the points in data set \code{Xp}
and the triangle \code{tri}
}
\description{
Plots the edges of the underlying or reflexivity graphs of
the Central Similarity Proximity Catch Digraph
(CS-PCD) whose vertices are the data points, \code{Xp}
and the triangle \code{tri}.
CS proximity regions
are constructed with respect to the triangle \code{tri}
with expansion parameter \eqn{t > 0},
i.e., edges may exist only for \code{Xp} points inside the triangle \code{tri}.

Edge regions are based on center \eqn{M=(m_1,m_2)}
in Cartesian coordinates
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of the triangle \code{tri};
default is \eqn{M=(1,1,1)}, i.e.,
the center of mass of \code{tri}.
With any interior center \code{M},
the edge regions are constructed using the extensions
of the lines combining vertices with \code{M}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:stamet2016;textual}{pcds.ugraph}).
}
\examples{
#\donttest{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10

set.seed(1)
Xp<-pcds::runif.tri(n,Tr)$g

M<-as.numeric(pcds::runif.tri(1,Tr)$g)
t<-1.5
plotCSedges.tri(Xp,Tr,t,M,edge.reg = TRUE,xlab="",ylab="")
plotCSedges.tri(Xp,Tr,t,M,ugraph="r",edge.reg = TRUE,xlab="",ylab="")

#can add vertex labels and text to the figure (with edge regions)
Ds<-pcds::prj.cent2edges(Tr,M); cent.name="M"

txt<-rbind(Tr,M,Ds)
xc<-txt[,1]+c(-.02,.02,.02,.02,.04,-0.03,-.01)
yc<-txt[,2]+c(.02,.02,.02,.07,.02,.04,-.06)
txt.str<-c("A","B","C",cent.name,"D1","D2","D3")
text(xc,yc,txt.str)
#}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotCSedges}}, \code{\link{plotASedges.tri}},
\code{\link{plotPEedges.tri}}, and \code{\link[pcds]{plotCSarcs.tri}}
}
\author{
Elvan Ceyhan
}
