% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{pcStan}
\alias{pcStan}
\title{Fit a paired comparison Stan model}
\usage{
pcStan(model, data, ...)
}
\arguments{
\item{model}{the name of a model}

\item{data}{a data list prepared for processing by Stan}

\item{...}{Additional options passed to \code{\link[rstan]{stan}}.}
}
\value{
A \code{\link[rstan:stanfit-class]{stanfit}} object.

An object of S4 class \code{\link[rstan:stanfit-class]{stanfit}}.
}
\description{
Uses \code{\link{findModel}} to find the appropriate
  model and then invokes \link[rstan:sampling]{sampling}.
}
\examples{
dl <- prepData(phyActFlowPropensity[,c(1,2,3)])
dl$varCorrection <- 5.0
\donttest{pcStan('unidim_adapt', data=dl)}  # takes more than 5 seconds
}
\seealso{
See \code{\link[rstan:sampling]{sampling}}, for which this function is
  a wrapper, for additional options. See \code{\link{prepData}} to
  create a suitable data list.  See
  \code{\link[rstan:print.stanfit]{print.stanfit}} for ways of getting tables
  summarizing parameter posteriors.

\code{\link{calibrateItems}}, \code{\link{outlierTable}}
}
