% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3tables_operations.R
\name{s3tables_list_namespaces}
\alias{s3tables_list_namespaces}
\title{Lists the namespaces within a table bucket}
\usage{
s3tables_list_namespaces(
  tableBucketARN,
  prefix = NULL,
  continuationToken = NULL,
  maxNamespaces = NULL
)
}
\arguments{
\item{tableBucketARN}{[required] The Amazon Resource Name (ARN) of the table bucket.}

\item{prefix}{The prefix of the namespaces.}

\item{continuationToken}{\code{ContinuationToken} indicates to Amazon S3 that the list is being
continued on this bucket with a token. \code{ContinuationToken} is obfuscated
and is not a real key. You can use this \code{ContinuationToken} for
pagination of the list results.}

\item{maxNamespaces}{The maximum number of namespaces to return in the list.}
}
\description{
Lists the namespaces within a table bucket. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-namespace.html}{Table namespaces} in the \emph{Amazon Simple Storage Service User Guide}.

See \url{https://www.paws-r-sdk.com/docs/s3tables_list_namespaces/} for full documentation.
}
\keyword{internal}
